/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.util.SHASign;
import com.bxm.localnews.thirdparty.config.KnowledgeProperties;
import com.bxm.localnews.thirdparty.service.PayKnowledgeService;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.service.UserService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payKnowledgeService")
public class PayKnowledgeServiceImpl
implements PayKnowledgeService {
    private HttpClientService httpClientService;
    private UserService userService;
    private KnowledgeProperties knowledgeProperties;

    @Autowired
    public PayKnowledgeServiceImpl(HttpClientService httpClientService, UserService userService, KnowledgeProperties knowledgeProperties) {
        this.httpClientService = httpClientService;
        this.userService = userService;
        this.knowledgeProperties = knowledgeProperties;
    }

    @Override
    public String exemptPayKnowledgeLogin(Long userId) {
        HashMap<String, String> map = this.generateExepmtLoginParams(userId);
        String jsonResult = this.httpClientService.doPostJson(this.knowledgeProperties.getUrl(), JSONObject.toJSONString(map));
        String jumpUrl = this.getUrlByResult(jsonResult);
        return jumpUrl;
    }

    private HashMap<String, String> generateExepmtLoginParams(Long userId) {
        UserInfoDTO dto = this.userService.getUserFromRedisDB(userId.longValue());
        HashMap map = Maps.newHashMap();
        map.put("uid", userId.toString());
        map.put("nickname", null == dto.getNickname() ? "" : dto.getNickname());
        map.put("headImgUrl", null == dto.getHeadImg() ? "" : dto.getHeadImg());
        map.put("appKey", this.knowledgeProperties.getAppKey());
        String signature = SHASign.sign((HashMap)map, (String)this.knowledgeProperties.getAppSecret());
        map.put("signature", signature);
        return map;
    }

    private String getUrlByResult(String jsonResult) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonResult).getJSONObject("result");
        String type = jsonObject.getString("type");
        String backUserId = jsonObject.getString("userId");
        String token = jsonObject.getString("token");
        String jumpUrl = this.knowledgeProperties.getJumpUrl() + "?" + "token=" + type + "_" + backUserId + "_" + token;
        return jumpUrl;
    }
}

