/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.config.CalendarProperties;
import com.bxm.localnews.thirdparty.dto.CalendarDTO;
import com.bxm.localnews.thirdparty.service.PerpetualCalendarService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PerpetualCalendarServiceImpl
implements PerpetualCalendarService {
    private HttpClientService httpClientService;
    private RedisStringAdapter redisStringAdapter;
    private CalendarProperties calendarProperties;

    @Autowired
    public PerpetualCalendarServiceImpl(HttpClientService httpClientService, RedisStringAdapter redisStringAdapter, CalendarProperties calendarProperties) {
        this.httpClientService = httpClientService;
        this.redisStringAdapter = redisStringAdapter;
        this.calendarProperties = calendarProperties;
    }

    @Override
    public CalendarDTO getTodayCalendar() {
        CalendarDTO calendarDTO = (CalendarDTO)this.redisStringAdapter.get(this.getCalendarKey(), CalendarDTO.class);
        if (calendarDTO == null) {
            calendarDTO = this.grapCalendarInfo();
        }
        return calendarDTO;
    }

    private KeyGenerator getCalendarKey() {
        KeyGenerator key = RedisConfig.THIRDPARTY_CALENDAR.copy().appendKey((Object)this.getToday());
        return key;
    }

    private String getToday() {
        Calendar cale = Calendar.getInstance();
        int year = cale.get(1);
        int month = cale.get(2) + 1;
        int day = cale.get(5);
        return year + "-" + month + "-" + day;
    }

    private CalendarDTO grapCalendarInfo() {
        CalendarDTO calendarDTO = new CalendarDTO();
        HashMap map = Maps.newHashMap();
        map.put("key", this.calendarProperties.getKey());
        map.put("date", this.getToday());
        String json = this.httpClientService.doGet(this.calendarProperties.getUrl(), (Map)map);
        if (StringUtils.isBlank((CharSequence)json)) {
            return calendarDTO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (!"0".equals(jsonObject.getString("error_code"))) {
            return calendarDTO;
        }
        JSONObject jo = jsonObject.getJSONObject("result").getJSONObject("data");
        TypeReference<CalendarDTO> typeReference = new TypeReference<CalendarDTO>(){};
        calendarDTO = (CalendarDTO)JSON.parseObject((String)jo.toJSONString(), (TypeReference)typeReference, (Feature[])new Feature[0]);
        String day = calendarDTO.getDate().substring(calendarDTO.getDate().lastIndexOf("-") + 1, calendarDTO.getDate().length());
        calendarDTO.setDay(day);
        this.redisStringAdapter.set(this.getCalendarKey(), (Object)calendarDTO, 259200L);
        return calendarDTO;
    }
}

