/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.util.MD5Sign;
import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.thirdparty.config.PointMallConfigProperties;
import com.bxm.localnews.thirdparty.constant.PointsMallStatusEnum;
import com.bxm.localnews.thirdparty.constant.PointsMallTypeEnum;
import com.bxm.localnews.thirdparty.domain.PointMallMapper;
import com.bxm.localnews.thirdparty.dto.OperateUserPointDTO;
import com.bxm.localnews.thirdparty.dto.PointMallDTO;
import com.bxm.localnews.thirdparty.dto.PointStoreBaseDTO;
import com.bxm.localnews.thirdparty.dto.UserPointDTO;
import com.bxm.localnews.thirdparty.service.PointMallService;
import com.bxm.localnews.thirdparty.vo.PointMall;
import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.param.StoreNeceParam;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pointMallSerivce")
public class PointMallServiceImpl
extends BaseService
implements PointMallService {
    private UserAmountService userAmountService;
    private PointMallConfigProperties pointMallConfigProperties;
    private PointMallMapper pointMallMapper;
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public PointMallServiceImpl(UserAmountService userAmountService, PointMallConfigProperties pointMallConfigProperties, PointMallMapper pointMallMapper, RedisStringAdapter redisStringAdapter) {
        this.userAmountService = userAmountService;
        this.pointMallConfigProperties = pointMallConfigProperties;
        this.pointMallMapper = pointMallMapper;
        this.redisStringAdapter = redisStringAdapter;
    }

    private KeyGenerator getPointsMallListKey() {
        return RedisConfig.POINTS_MALL_KEY.copy().appendKey((Object)"list");
    }

    private List<PointMall> getAllPointMall() {
        TypeReference<List<PointMall>> typeReference = new TypeReference<List<PointMall>>(){};
        List pointMalls = (List)this.redisStringAdapter.get(this.getPointsMallListKey(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)pointMalls) && CollectionUtils.isNotEmpty((Collection)(pointMalls = this.pointMallMapper.selectAllByStatus(PointsMallStatusEnum.ON_SHELF.getStatus())))) {
            this.redisStringAdapter.set(this.getPointsMallListKey(), (Object)pointMalls);
        }
        return pointMalls;
    }

    @Override
    public List<PointMallDTO> getPointsMallByType(Long userId, String type) {
        List<PointMall> pointMalls = this.getAllPointMall();
        ArrayList<PointMallDTO> pointMallDTOS = new ArrayList<PointMallDTO>();
        for (PointMall pointMall : pointMalls) {
            if (!Byte.valueOf(type).equals(pointMall.getType())) continue;
            PointMallDTO pointMallDTO = this.getPointMallDTOByPointMall(pointMall);
            pointMallDTOS.add(pointMallDTO);
        }
        return pointMallDTOS;
    }

    @Override
    public String getPointMallById(Long id, Long userId) {
        List<PointMall> pointMalls = this.getAllPointMall();
        for (PointMall pointMall : pointMalls) {
            if (!pointMall.getId().equals(id)) continue;
            String jumpUrl = "";
            jumpUrl = PointsMallTypeEnum.STORE.getType().equals(pointMall.getType()) ? this.generateJumpUrl(userId, "") : this.generateJumpUrl(userId, pointMall.getUrl());
            return jumpUrl;
        }
        return "";
    }

    @Override
    public UserPointDTO selectJbBalanceByUserId(StoreNeceParam storeNeceParam) {
        HashMap<String, String> map = this.addCommonParams(storeNeceParam);
        String md5Str = MD5Sign.sign(map, (String)this.pointMallConfigProperties.getAppSecret());
        if (!md5Str.equals(storeNeceParam.getSign())) {
            return UserPointDTO.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        String point = this.userAmountService.selectJbBalanceByUserId(storeNeceParam).toString();
        return UserPointDTO.success((String)point);
    }

    @Override
    public OperateUserPointDTO deductUserBalance(DeductPointParam deductPointParam) {
        HashMap<String, String> map = this.addCommonParams((StoreNeceParam)deductPointParam);
        map.put("point", deductPointParam.getPoint().toString());
        map.put("orderNum", deductPointParam.getOrderNum());
        String description = this.decode(deductPointParam.getDescription());
        map.put("description", description);
        String md5Str = MD5Sign.sign(map, (String)this.pointMallConfigProperties.getAppSecret());
        if (!md5Str.equals(deductPointParam.getSign())) {
            return OperateUserPointDTO.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        String appOrderNum = this.generateOrderNo();
        deductPointParam.setDescription(description);
        Boolean isDeduct = this.userAmountService.deductUserBalance(deductPointParam);
        if (!isDeduct.booleanValue()) {
            return OperateUserPointDTO.fail((String)"\u91d1\u5e01\u4e0d\u8db3");
        }
        return OperateUserPointDTO.success((String)appOrderNum);
    }

    @Override
    public PointStoreBaseDTO deductConfirmUserBalance(DeductPointParam deductPointParam) {
        HashMap<String, String> map = this.addCommonParams((StoreNeceParam)deductPointParam);
        map.put("orderNum", deductPointParam.getOrderNum());
        map.put("status", deductPointParam.getStatus());
        String description = this.decode(deductPointParam.getDescription());
        map.put("description", description);
        String md5Str = MD5Sign.sign(map, (String)this.pointMallConfigProperties.getAppSecret());
        if (!md5Str.equals(deductPointParam.getSign())) {
            return PointStoreBaseDTO.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        deductPointParam.setDescription(description);
        this.userAmountService.deductConfirmUserBalance(deductPointParam);
        return PointStoreBaseDTO.success();
    }

    @Override
    public OperateUserPointDTO addUserBalance(DeductPointParam deductPointParam) {
        HashMap<String, String> map = this.addCommonParams((StoreNeceParam)deductPointParam);
        map.put("point", deductPointParam.getPoint().toString());
        map.put("orderNum", deductPointParam.getOrderNum());
        String md5Str = MD5Sign.sign(map, (String)this.pointMallConfigProperties.getAppSecret());
        if (!md5Str.equals(deductPointParam.getSign())) {
            return OperateUserPointDTO.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        String appOrderNum = this.generateOrderNo();
        String description = "\u6dfb\u52a0\u91d1\u5e01";
        String status = "ok";
        deductPointParam.setAppOrderNum(appOrderNum);
        deductPointParam.setDescription(description);
        deductPointParam.setStatus(status);
        this.userAmountService.addUserBalance(deductPointParam);
        return OperateUserPointDTO.success((String)appOrderNum);
    }

    private String generateOrderNo() {
        String orderPrefix = "Balance";
        return NidGeneratorUtil.getOrderNo((String)orderPrefix);
    }

    private PointMallDTO getPointMallDTOByPointMall(PointMall pointMall) {
        PointMallDTO pointMallDTO = new PointMallDTO();
        pointMallDTO.setImg(pointMall.getImg());
        pointMallDTO.setTitle(pointMall.getTitle());
        pointMallDTO.setId(pointMall.getId());
        return pointMallDTO;
    }

    private String generateJumpUrl(Long userId, String url) {
        HashMap map = Maps.newHashMap();
        this.addCommonParams(map, userId);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            map.put("redirect", url);
        }
        String sign = MD5Sign.sign((HashMap)map, (String)this.pointMallConfigProperties.getAppSecret());
        map.put("sign", sign);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            url = this.encode(url);
            map.put("redirect", url);
        }
        return this.getFullLink(map);
    }

    private String getFullLink(Map<String, String> map) {
        String params = Joiner.on((String)"&").withKeyValueSeparator("=").join(map);
        String jumpUrl = this.pointMallConfigProperties.getStoreUrl() + "?" + params;
        return jumpUrl;
    }

    private HashMap<String, String> addCommonParams(StoreNeceParam storeNeceParam) {
        HashMap map = Maps.newHashMap();
        map.put("appUid", storeNeceParam.getAppUid());
        map.put("appKey", storeNeceParam.getAppKey());
        map.put("timestamp", storeNeceParam.getTimestamp());
        return map;
    }

    private void addCommonParams(Map<String, String> map, Long userId) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        map.put("appUid", String.valueOf(userId));
        map.put("appKey", this.pointMallConfigProperties.getAppKey());
        map.put("appType", this.pointMallConfigProperties.getAppType());
        map.put("timestamp", timestamp);
    }

    private String decode(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                str = this.decode(str, "utf-8");
            }
            catch (Exception e) {
                this.logger.error("\u89e3\u7801\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
        }
        return str;
    }

    private String decode(String str, String enc) throws Exception {
        return URLDecoder.decode(str, enc);
    }

    private String encode(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                str = this.encode(str, "utf-8");
            }
            catch (Exception e) {
                this.logger.error("\u7f16\u7801\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
        }
        return str;
    }

    private String encode(String str, String enc) throws Exception {
        return URLEncoder.encode(str, enc);
    }
}

