/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.thirdparty.constant.GlobalFlagEnum;
import com.bxm.localnews.thirdparty.constant.ToolsSensitiveFlagEnum;
import com.bxm.localnews.thirdparty.constant.ToolsStatusEnum;
import com.bxm.localnews.thirdparty.domain.ToolsMapper;
import com.bxm.localnews.thirdparty.dto.ToolsDTO;
import com.bxm.localnews.thirdparty.service.ToolsService;
import com.bxm.localnews.thirdparty.vo.Tools;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ToolsServiceImpl
implements ToolsService {
    private ToolsMapper toolsMapper;
    private RedisHashMapAdapter redisHashMapAdapter;
    private AppVersionSupplyService appVersionSupplyService;

    @Autowired
    public ToolsServiceImpl(ToolsMapper toolsMapper, RedisHashMapAdapter redisHashMapAdapter, AppVersionSupplyService appVersionSupplyService) {
        this.toolsMapper = toolsMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.appVersionSupplyService = appVersionSupplyService;
    }

    @Override
    public List<ToolsDTO> getToolsByAreaCode(String areaCode, BasicParam basicParam) {
        Boolean isPublishState = this.appVersionSupplyService.getPublishState(basicParam);
        List<ToolsDTO> toolsDTOS = this.getToolDTOsByToolsList(areaCode, isPublishState);
        return toolsDTOS;
    }

    private List<Tools> getAllTools(String areaCode) {
        TypeReference<List<Tools>> typeReference = new TypeReference<List<Tools>>(){};
        List toolsList = (List)this.redisHashMapAdapter.get(this.getToolsListKey(), areaCode, (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)toolsList) && CollectionUtils.isNotEmpty((Collection)(toolsList = this.toolsMapper.getAllToolsByStatusAndAreaCode(ToolsStatusEnum.ENABLE.getStatus(), areaCode, GlobalFlagEnum.IS_GLOBAL.getState())))) {
            this.redisHashMapAdapter.put(this.getToolsListKey(), areaCode, (Object)toolsList);
        }
        return toolsList;
    }

    private KeyGenerator getToolsListKey() {
        return RedisConfig.THIRDPARTY_AREACODE_TOOLS.copy().appendKey((Object)"list");
    }

    private ToolsDTO getToolsDTOByTools(Tools tools) {
        ToolsDTO toolsDTO = new ToolsDTO();
        toolsDTO.setImgUrl(tools.getImgUrl());
        toolsDTO.setTitle(tools.getTitle());
        toolsDTO.setUrl(tools.getUrl());
        return toolsDTO;
    }

    private List<ToolsDTO> getToolDTOsByToolsList(String areaCode, Boolean isPublishState) {
        ArrayList toolsDTOS = Lists.newArrayList();
        List<Tools> toolsList = this.getAllTools(areaCode);
        if (CollectionUtils.isNotEmpty(toolsList)) {
            for (Tools tools : toolsList) {
                if (isPublishState.booleanValue() && ToolsSensitiveFlagEnum.IS_SENSITIVE.getState().equals(tools.getSensitiveFlag())) continue;
                ToolsDTO toolsDTO = this.getToolsDTOByTools(tools);
                toolsDTOS.add(toolsDTO);
            }
        }
        return toolsDTOS;
    }
}

