/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.config.WeatherProperties;
import com.bxm.localnews.thirdparty.constant.WeatherEnum;
import com.bxm.localnews.thirdparty.dto.WeatherDTO;
import com.bxm.localnews.thirdparty.service.WeatherService;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeatherServiceImpl
implements WeatherService {
    private WeatherProperties weatherProperties;
    private HttpClientService httpClientService;
    private RedisStringAdapter redisStringAdapter;
    private AliyunOSSService aliyunOSSService;

    @Autowired
    public WeatherServiceImpl(WeatherProperties weatherProperties, HttpClientService httpClientService, RedisStringAdapter redisStringAdapter, AliyunOSSService aliyunOSSService) {
        this.weatherProperties = weatherProperties;
        this.httpClientService = httpClientService;
        this.redisStringAdapter = redisStringAdapter;
        this.aliyunOSSService = aliyunOSSService;
    }

    @Override
    public WeatherDTO getWeatherByAdcode(String adcode) {
        WeatherDTO weatherDTO = (WeatherDTO)this.redisStringAdapter.get(this.getWeatherKey(adcode), WeatherDTO.class);
        if (weatherDTO == null) {
            HashMap<String, String> map = this.addCommonParams(adcode);
            String json = this.httpClientService.doGet(this.weatherProperties.getWeatherUrl(), map);
            weatherDTO = this.getWeatherByJson(json);
        }
        return weatherDTO;
    }

    private HashMap<String, String> addCommonParams(String adcode) {
        HashMap map = Maps.newHashMap();
        map.put("key", this.weatherProperties.getKey());
        map.put("city", adcode);
        return map;
    }

    private WeatherDTO getWeatherByJson(String json) {
        WeatherDTO weatherDTO = new WeatherDTO();
        if (StringUtils.isBlank((CharSequence)json)) {
            return weatherDTO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if ("0".equals(jsonObject.getString("status"))) {
            return weatherDTO;
        }
        JSONArray jsonArray = jsonObject.getJSONArray("lives");
        TypeReference<List<WeatherDTO>> typeReference = new TypeReference<List<WeatherDTO>>(){};
        List weatherDTOS = (List)JSON.parseObject((String)jsonArray.toJSONString(), (TypeReference)typeReference, (Feature[])new Feature[0]);
        if (CollectionUtils.isNotEmpty((Collection)weatherDTOS)) {
            WeatherEnum weatherEnum = WeatherEnum.getWeatherEnum((weatherDTO = (WeatherDTO)weatherDTOS.get(0)).getWeather());
            weatherDTO.setWeather(weatherEnum == null ? "" : weatherEnum.getName());
            weatherDTO.setWeatherImg(weatherEnum == null ? "" : weatherEnum.getImg());
            weatherDTO.setTemperature(weatherDTO.getTemperature() + "\u00b0");
            this.redisStringAdapter.set(this.getWeatherKey(weatherDTO.getAdcode()), (Object)weatherDTO, 1800L);
        }
        return weatherDTO;
    }

    private KeyGenerator getWeatherKey(String adcode) {
        return RedisConfig.THIRDPARTY_WEATHER.copy().appendKey((Object)adcode);
    }
}

