/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WxMpAuthService;
import com.bxm.localnews.user.service.UserAuthSupplyService;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.newidea.component.tools.StringUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxMpAuthServiceImpl
implements WxMpAuthService {
    private UserAuthSupplyService userAuthSupplyService;
    private WxMpService wxMpService;

    @Autowired
    public WxMpAuthServiceImpl(UserAuthSupplyService userAuthSupplyService, WxMpService wxMpService) {
        this.userAuthSupplyService = userAuthSupplyService;
        this.wxMpService = wxMpService;
    }

    @Override
    public WxUserInfo getUserIdByCode(String code) {
        WxUserInfo wxUserInfo = this.getWxUserInfoByCode(code);
        UserAuth userAuth = this.userAuthSupplyService.selectByUserAuth(wxUserInfo.getOpenid());
        if (null != userAuth) {
            wxUserInfo.setUserId(userAuth.getUserId());
        }
        return wxUserInfo;
    }

    private WxUserInfo getWxUserInfoByCode(String code) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        if (StringUtils.isBlank((CharSequence)code)) {
            return wxUserInfo;
        }
        try {
            WxMpOAuth2AccessToken wxMpOAuth2AccessToken = this.wxMpService.oauth2getAccessToken(code);
            WxMpUser wxMpUser = this.wxMpService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
            wxUserInfo = this.convertWxMpUser(wxMpUser);
        }
        catch (WxErrorException e) {
            return wxUserInfo;
        }
        return wxUserInfo;
    }

    private WxUserInfo convertWxMpUser(WxMpUser wxMpUser) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        wxUserInfo.setOpenid(wxMpUser.getOpenId());
        wxUserInfo.setHeadImg(wxMpUser.getHeadImgUrl());
        wxUserInfo.setNickname(wxMpUser.getNickname());
        return wxUserInfo;
    }
}

