/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.base.dto.LocationDTO;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.constant.AdvertStatusEunm;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.constant.GlobalFlagEnum;
import com.bxm.localnews.thirdparty.domain.AdvertAreaMapper;
import com.bxm.localnews.thirdparty.domain.AdvertMapper;
import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.vo.Advert;
import com.bxm.localnews.thirdparty.vo.AdvertArea;
import com.bxm.localnews.thirdparty.vo.AdvertRecord;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertServiceImpl
implements AdvertService {
    private static final int AREA_CODE_LENGTH = 12;
    private AdvertMapper advertMapper;
    private AdvertAreaMapper advertAreaMapper;
    private RedisStringAdapter redisStringAdapter;
    private LocationFacadeService locationFacadeService;

    @Autowired
    public AdvertServiceImpl(AdvertMapper advertMapper, AdvertAreaMapper advertAreaMapper, RedisStringAdapter redisStringAdapter, LocationFacadeService locationFacadeService) {
        this.advertMapper = advertMapper;
        this.advertAreaMapper = advertAreaMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.locationFacadeService = locationFacadeService;
    }

    private List<Advert> getAllAdvertByType(Byte type) {
        TypeReference<List<Advert>> typeReference = new TypeReference<List<Advert>>(){};
        List adverts = (List)this.redisStringAdapter.get(this.getAdvertListKey(type), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)adverts) && CollectionUtils.isNotEmpty((Collection)(adverts = this.advertMapper.queryAdByType(type, AdvertStatusEunm.PUTAWAY.getType())))) {
            this.redisStringAdapter.set(this.getAdvertListKey(type), (Object)adverts);
        }
        return adverts;
    }

    public List<AdvertDTO> queryAdByType(Byte type, String areaCode, Long userId) {
        List<Object> longList = Lists.newArrayList();
        List<Advert> advertList = this.getAllAdvertByType(type);
        if (StringUtils.isNotBlank((CharSequence)areaCode)) {
            longList = this.getAdvertAreasByAreaCode(areaCode);
        }
        List<AdvertDTO> advertDTOList = this.getAdvertDTOs(advertList, longList);
        if (AdvertTypeEnum.SHOUYE_TANCH.getType().equals(String.valueOf(type))) {
            List<AdvertDTO> advertDTOS = this.filterAdvertInfo(userId, advertDTOList);
            return advertDTOS;
        }
        if (userId != null && CollectionUtils.isNotEmpty(advertDTOList)) {
            this.recordAdvert(userId, advertDTOList);
        }
        return advertDTOList;
    }

    private void recordAdvert(Long userId, List<AdvertDTO> advertDTOList) {
        ArrayList advertRecords = Lists.newArrayList();
        Date now = new Date();
        advertDTOList.forEach(advertDTO -> {
            AdvertRecord advertRecord = new AdvertRecord();
            advertRecord.setAdvertId(advertDTO.getId());
            advertRecord.setUserId(userId);
            advertRecord.setViewTime(now);
            advertRecords.add(advertRecord);
        });
        if (CollectionUtils.isEmpty((Collection)advertRecords)) {
            return;
        }
        this.advertMapper.recordAdvert((List)advertRecords);
    }

    public Advert selectByPrimaryKey(Long id) {
        return this.advertMapper.selectByPrimaryKey(id);
    }

    public List<AdvertDTO> getListAds(int size) {
        return this.advertMapper.getListAds(Integer.valueOf(size));
    }

    private List<AdvertDTO> getAdvertDTOs(List<Advert> advertList, List<Long> longList) {
        ArrayList advertDTOList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(advertList)) {
            for (Advert advert : advertList) {
                if (GlobalFlagEnum.IS_NOT_GLOBAL.getState().equals(advert.getGlobalFlag()) && !longList.contains(advert.getId())) continue;
                AdvertDTO advertDTO = this.getAdvertDTOByAdvert(advert);
                advertDTOList.add(advertDTO);
            }
        }
        return advertDTOList;
    }

    private KeyGenerator getAdvertListKey(Byte type) {
        return RedisConfig.THIRDPARTY_TYPE_ADVERT.copy().appendKey((Object)type).appendKey((Object)"list");
    }

    private AdvertDTO getAdvertDTOByAdvert(Advert advert) {
        AdvertDTO advertDTO = new AdvertDTO();
        BeanUtils.copyProperties((Object)advert, (Object)advertDTO);
        return advertDTO;
    }

    private List<Long> getAdvertAreasByAreaCode(String areaCode) {
        areaCode = this.complteAreaCode(areaCode);
        return this.advertAreaMapper.getAllAdvertAreaByAreaCode(areaCode).stream().map(AdvertArea::getAdvertId).collect(Collectors.toList());
    }

    private String complteAreaCode(String areaCode) {
        LocationDTO locationDTO;
        String fullCode = areaCode;
        if (12 != fullCode.length() && null == (locationDTO = this.locationFacadeService.getLocationByCode(fullCode = areaCode + "000000"))) {
            fullCode = areaCode.substring(0, 4) + "00000000";
        }
        return fullCode;
    }

    private List<AdvertDTO> filterAdvertInfo(Long userId, List<AdvertDTO> list) {
        List<Object> advertDTOS = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return advertDTOS;
        }
        advertDTOS = list.stream().filter(advertDTO -> this.checkRemoveAdvertInfo(userId, advertDTO.getId(), advertDTO.getShowType()) == false).collect(Collectors.toList());
        return advertDTOS;
    }

    private Boolean checkRemoveAdvertInfo(Long userId, Long advertId, Byte showType) {
        if (this.redisStringAdapter.hasKey(this.getAdvertByTypeKey(showType, userId, advertId)).booleanValue()) {
            return true;
        }
        if (showType != null) {
            if (showType == 3) {
                this.redisStringAdapter.set(this.getAdvertByTypeKey(showType, userId, advertId), (Object)userId, (long)DateUtils.getCurSeconds());
            } else {
                this.redisStringAdapter.set(this.getAdvertByTypeKey(showType, userId, advertId), (Object)userId);
            }
        }
        return false;
    }

    private KeyGenerator getAdvertByTypeKey(Byte showType, Long userId, Long advertId) {
        return RedisConfig.THIRDPARTY_SHOW_TYPE_ADVERT.copy().appendKey((Object)(advertId + "_" + showType + "_" + userId));
    }
}

