/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.domain.BannerMapper;
import com.bxm.localnews.thirdparty.service.BannerService;
import com.bxm.localnews.thirdparty.vo.Banner;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class BannerServiceImpl
implements BannerService {
    private BannerMapper bannerMapper;

    @Autowired
    public BannerServiceImpl(BannerMapper bannerMapper) {
        this.bannerMapper = bannerMapper;
    }

    @Override
    public List<Banner> queryBannerList(Byte bannerType) {
        return this.bannerMapper.queryList(bannerType);
    }

    @Override
    public List<Banner> listBanner(Map<String, Object> searchMap, int current, int pageSize) {
        PageHelper.startPage((int)current, (int)pageSize);
        List list = this.bannerMapper.findBySelective(searchMap);
        return list;
    }

    @Override
    public Json insertSelective(Banner Banner2, Integer functionId) {
        Banner2.setAddTime(new Date());
        this.bannerMapper.insertSelective(Banner2);
        return ResultUtil.genSuccessMsg();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Json updateBySelective(Banner Banner2, Integer functionId) {
        Banner2.setUpdateTime(new Date());
        this.bannerMapper.updateByPrimaryKeySelective(Banner2);
        return ResultUtil.genSuccessMsg();
    }

    @Override
    public Json changeState(Long bannerId, String status) {
        Banner bannerInfo = this.bannerMapper.selectByPrimaryKey(Integer.valueOf(bannerId.intValue()));
        if (bannerInfo == null) {
            return ResultUtil.genFailedResult((String)"\u64cd\u4f5c\u5931\u8d25,\u65e0\u8be5\u529f\u80fd");
        }
        bannerInfo.setStatus(Byte.valueOf(status));
        bannerInfo.setUpdateTime(new Date());
        int i = this.bannerMapper.updateByPrimaryKeySelective(bannerInfo);
        if (i > 0) {
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult((String)"\u7cfb\u7edf\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @Override
    public Banner getBanner(Integer bannerId) {
        return this.bannerMapper.selectByPrimaryKey(bannerId);
    }

    @Override
    public int updateBannerStatusByIds(Long[] ids, Byte status) {
        return this.bannerMapper.updateBannerStatusByIds(ids, status);
    }
}

