/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.util.SHASign;
import com.bxm.localnews.thirdparty.config.KnowledgeProperties;
import com.bxm.localnews.thirdparty.service.PayKnowledgeService;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.service.UserService;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payKnowledgeService")
public class PayKnowledgeServiceImpl
implements PayKnowledgeService {
    private HttpClientService httpClientService;
    private UserService userService;
    private KnowledgeProperties knowledgeProperties;

    @Autowired
    public PayKnowledgeServiceImpl(HttpClientService httpClientService, UserService userService, KnowledgeProperties knowledgeProperties) {
        this.httpClientService = httpClientService;
        this.userService = userService;
        this.knowledgeProperties = knowledgeProperties;
    }

    @Override
    public String exemptPayKnowledgeLogin(Long userId, Integer isLogin, String redirectUrl) {
        if (isLogin == 0) {
            return this.knowledgeProperties.getJumpUrl();
        }
        HashMap<String, String> map = this.generateExepmtLoginParams(userId);
        String jsonResult = this.httpClientService.doPostJson(this.knowledgeProperties.getUrl(), JSONObject.toJSONString(map));
        String jumpUrl = this.getUrlByResult(jsonResult, redirectUrl);
        return jumpUrl;
    }

    private HashMap<String, String> generateExepmtLoginParams(Long userId) {
        UserInfoDTO dto = this.userService.getUserFromRedisDB(userId.longValue());
        HashMap map = Maps.newHashMap();
        map.put("uid", userId.toString());
        if (dto == null) {
            map.put("nickname", "");
            map.put("headImgUrl", "");
            map.put("nickname", "");
        } else {
            map.put("nickname", null == dto.getNickname() ? "" : dto.getNickname());
            map.put("headImgUrl", null == dto.getHeadImg() ? "" : dto.getHeadImg());
        }
        map.put("appKey", this.knowledgeProperties.getAppKey());
        String signature = SHASign.sign((HashMap)map, (String)this.knowledgeProperties.getAppSecret());
        map.put("signature", signature);
        return map;
    }

    private String getUrlByResult(String jsonResult, String redirectUrl) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonResult).getJSONObject("result");
        String type = jsonObject.getString("type");
        String backUserId = jsonObject.getString("userId");
        String token = jsonObject.getString("token");
        StringBuilder jumpUrl = new StringBuilder().append(this.knowledgeProperties.getJumpUrl()).append("?").append("token=").append(type).append("_").append(backUserId).append("_").append(token);
        if (StringUtils.isNotBlank((CharSequence)redirectUrl)) {
            jumpUrl.append(redirectUrl);
        }
        return jumpUrl.toString();
    }

    private String getTypeByRedirectUrl(String redirectUrl) {
        String str = StringUtils.substringAfterLast((String)redirectUrl, (String)"?");
        Map map = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)str);
        return (String)map.get("type");
    }
}

