package com.bxm.localnews.thirdparty.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("thirdparty.config")
public class ThirdPartyProperties {

    /**
     * 设备验证token
     */
    private String machineToken;

    /**
     * 设备接入码
     */
    private String machineEncodingAESKey;

    /**
     * 机器对应的appid
     */
    private String machineAppId;

    /**
     * 显示app弹窗广告
     */
    private boolean showPopAdvert;

    public boolean isShowPopAdvert() {
        return showPopAdvert;
    }

    public void setShowPopAdvert(boolean showPopAdvert) {
        this.showPopAdvert = showPopAdvert;
    }

    public String getMachineToken() {
        return machineToken;
    }

    public void setMachineToken(String machineToken) {
        this.machineToken = machineToken;
    }

    public String getMachineEncodingAESKey() {
        return machineEncodingAESKey;
    }

    public void setMachineEncodingAESKey(String machineEncodingAESKey) {
        this.machineEncodingAESKey = machineEncodingAESKey;
    }

    public String getMachineAppId() {
        return machineAppId;
    }

    public void setMachineAppId(String machineAppId) {
        this.machineAppId = machineAppId;
    }

}
