package com.bxm.localnews.thirdparty.constant;

/**
 * @author zhaoyadong 2018/10/18 10:58
 * @desc
 */
public enum PointsMallStatusEnum {

    NOT_ON_SHELF(0, "未上架"),

    ON_SHELF(1, "已上架");

    private Integer status;

    private String name;

    PointsMallStatusEnum(Integer status, String name) {
        this.status = status;
        this.name = name;
    }

    public static String getPointsMallStatusEnum(Integer status) {
        for (PointsMallStatusEnum pointsMallStatusEnum : PointsMallStatusEnum.values()) {
            if (pointsMallStatusEnum.getStatus().equals(status)) {
                return pointsMallStatusEnum.getName();
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
