package com.bxm.localnews.thirdparty.service.impl;

import java.util.HashMap;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.config.RecruitProperties;
import com.bxm.localnews.thirdparty.dto.RecruitDTO;
import com.bxm.localnews.thirdparty.service.BlueCollarService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2018/10/25 17:15
 * @desc
 */
@Service
public class BlueCollarServiceImpl implements BlueCollarService {

    private final static String params = "?isLogin={isLogin}&userId={userId}&addressLon={lng}&addressLat={lat}" +
            "&areaCode={areaCode}&areaName={areaName}&workType={workType}";

    private HttpClientService httpClientService;

    private RecruitProperties recruitProperties;

    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public BlueCollarServiceImpl(HttpClientService httpClientService, RecruitProperties recruitProperties,
                                 RedisStringAdapter redisStringAdapter) {
        this.httpClientService = httpClientService;
        this.recruitProperties = recruitProperties;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public RecruitDTO getRecruits(String areaCode) {

        RecruitDTO recruitDTO = this.redisStringAdapter.get(getRecruitKey(areaCode), RecruitDTO.class);
        if (recruitDTO == null) {
            recruitDTO = getRecruitByAreaCode(areaCode);
        }

        // 拼接参数
        recruitDTO.setRedirectUrl(recruitDTO.getRedirectUrl() + params);

        return recruitDTO;
    }

    private RecruitDTO getRecruitByAreaCode(String areaCode) {
        RecruitDTO recruitDTO = new RecruitDTO();
        HashMap<String, String> map = Maps.newHashMap();
        map.put("areaCode", areaCode);
        map.put("limitSize", recruitProperties.getLimitSize().toString());

        String json = httpClientService.doGet(recruitProperties.getUrl(), map);
        if (StringUtils.isBlank(json)) {
            return recruitDTO;
        }

        JSONObject jsonObject = JSONObject.parseObject(json);

        if (!jsonObject.getBoolean("successed")) {
            return recruitDTO;
        }

        JSONObject jo = jsonObject.getJSONObject("returnValue");
        TypeReference<RecruitDTO> typeReference = new TypeReference<RecruitDTO>() {
        };
        recruitDTO = JSON.parseObject(jo.toJSONString(), typeReference);

        this.redisStringAdapter.set(getRecruitKey(areaCode), recruitDTO, 5 * 60);
        return recruitDTO;
    }

    /**
     * 获取存放在redis中的key值
     *
     * @return key值
     */
    private KeyGenerator getRecruitKey(String areaCode) {
        KeyGenerator key = RedisConfig.THIRDPARTY_RECRUIT.copy().appendKey(areaCode);
        return key;
    }
}
