package com.bxm.localnews.thirdparty.service.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.constant.EnjoyTypeEnum;
import com.bxm.localnews.thirdparty.dto.*;
import com.bxm.localnews.thirdparty.service.EnjoyEatService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2018/10/30 16:47
 * @desc
 */
@Service
public class EnjoyEatServieImpl extends BaseService implements EnjoyEatService {

    private RedisHashMapAdapter redisHashMapAdapter;

    private RedisStringAdapter redisStringAdapter;

    private SequenceCreater sequenceCreater;

    @Autowired
    public EnjoyEatServieImpl(RedisHashMapAdapter redisHashMapAdapter, SequenceCreater sequenceCreater,
                              RedisStringAdapter redisStringAdapter) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.sequenceCreater = sequenceCreater;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public EnjoyBaseDTO getEnjoyBaseDTOByCode(String areaCode) {
        EnjoyBaseDTO enjoyBaseDTO = getEnjoyBaseDTO(areaCode);
        return enjoyBaseDTO;
    }

    @Override
    public EnjoyDetailDTO getEnjoyDetailDTO(Long id) {

        return this.redisStringAdapter.get(this.generateKeyById(id), EnjoyDetailDTO.class);
    }

    /**
     * 获取吃喝玩乐类列表的key
     *
     * @return
     */
    private KeyGenerator getEnjoyEatListKey() {
        return RedisConfig.THIRDPARTY_ENJOY_EAT.copy().appendKey("list");
    }

    /**
     * 根据code和type获取对应的key
     *
     * @param areaCode
     * @param type
     * @return
     */
    private String generateKeyByCodeAndType(String areaCode, Byte type) {
        return new StringBuilder().append(areaCode).append("_").append(type).toString();
    }

    /**
     * 根据id获取对应的key
     *
     * @param id
     * @return
     */
    private KeyGenerator generateKeyById(Long id) {
        return RedisConfig.THIRDPARTY_ENJOY_EAT.copy().appendKey(id);
    }

    /**
     * 根据code获取对应的key
     *
     * @param areaCode
     * @return
     */
    private String generateKeyByCodeAndType(String areaCode) {
        return new StringBuilder().append(areaCode).toString();
    }

    /**
     * 获取对应的json文件路径
     *
     * @param areaCode
     * @param type
     * @return
     */
    private String getOSSUrlByCodeAndType(String areaCode, Byte type) {
        String genUrl = "https://bxm-news.oss-cn-hangzhou.aliyuncs.com/localnews_prod/enjoy_eat/";

        return new StringBuilder().append(genUrl).append(generateKeyByCodeAndType(areaCode, type)).append(".json").toString();
    }

    /**
     * 读取oss对应的json文件
     *
     * @param areaCode
     * @return
     */
    private EnjoyEatBaseDTO readJsonFile(String areaCode) {
        //读取吃喝的数据
        String url = getOSSUrlByCodeAndType(areaCode, EnjoyTypeEnum.ENJOY.getType());
        EnjoyEatBaseDTO enjoyEatBaseDTO = new EnjoyEatBaseDTO();
        enjoyEatBaseDTO.setEatList(getEnjoyEatList(this.readFile(url)));

        //读取玩乐的数据
        url = getOSSUrlByCodeAndType(areaCode, EnjoyTypeEnum.EAT.getType());
        enjoyEatBaseDTO.setEnjoyList(getEnjoyEatList(this.readFile(url)));

        return enjoyEatBaseDTO;
    }

    /**
     * 获取吃喝玩乐的列表
     *
     * @param url
     * @return
     */
    private List<EnjoyEatDTO> getEnjoyEatList(String url) {
        List<EnjoyEatDTO> list = Lists.newArrayList();
        if (StringUtils.isBlank(url)) {
            return list;
        }

        JSONArray jsonArray = JSONObject.parseArray(url);
        for (Iterator iterator = jsonArray.iterator(); iterator.hasNext(); ) {
            JSONObject jsonObject = (JSONObject) iterator.next();
            EnjoyEatDTO enjoyEatDTO = new EnjoyEatDTO();
            enjoyEatDTO.setId(sequenceCreater.nextLongId());
            enjoyEatDTO.setType(EnjoyTypeEnum.ENJOY.getType());
            String name = jsonObject.getString("title");
            enjoyEatDTO.setName(name);
            String imgUrl = jsonObject.getString("main_pic");
            enjoyEatDTO.setUrl(imgUrl);
            String time = jsonObject.getString("time");
            enjoyEatDTO.setBusinessTime(time);
            String address = jsonObject.getString("address");
            enjoyEatDTO.setAddress(address);
            String phone = jsonObject.getString("tel");
            enjoyEatDTO.setPhone(phone);

            //图片mapA
            LinkedHashMap<String, List<String>> enjoyMap = Maps.newLinkedHashMap();
            //推荐菜
            List<String> recommondList = Lists.newArrayList();
            //全部
            List<String> allEnjoyCategoryDTOList = Lists.newArrayList();
            //环境
            List<String> envEnjoyCategoryDTOList = Lists.newArrayList();
            //菜
            List<String> foodEnjoyCategoryDTOList = Lists.newArrayList();
            //价位
            List<String> priceEnjoyCategoryDTOList = Lists.newArrayList();

            JSONArray foodJsonArray = jsonObject.getJSONArray("shop_food_msg");
            if (CollectionUtils.isNotEmpty(foodJsonArray)) {
                for (Iterator foodIterator = foodJsonArray.iterator(); foodIterator.hasNext(); ) {
                    JSONObject foodJsonObject = (JSONObject) foodIterator.next();

                    String foodName = foodJsonObject.getString("name");
                    if (StringUtils.isNotBlank(foodName)) {
                        recommondList.add(foodName);
                    }

                    String pic = foodJsonObject.getString("pic");
                    if (StringUtils.isNotBlank(pic)) {
                        allEnjoyCategoryDTOList.add(pic);
                        foodEnjoyCategoryDTOList.add(pic);
                    }
                }

            }
            enjoyEatDTO.setRecommondFood(recommondList);

            JSONArray envJsonArray = jsonObject.getJSONArray("shop_pic_env");
            if (CollectionUtils.isNotEmpty(envJsonArray)) {
                for (Iterator envIterator = envJsonArray.iterator(); envIterator.hasNext(); ) {
                    String picStr = (String) envIterator.next();
                    if (StringUtils.isNotBlank(picStr)) {
                        allEnjoyCategoryDTOList.add(picStr);
                        envEnjoyCategoryDTOList.add(picStr);
                    }
                }
            }

            JSONArray priceJsonArray = jsonObject.getJSONArray("shop_pic_price");
            if (CollectionUtils.isNotEmpty(priceJsonArray)) {
                for (Iterator priceIterator = priceJsonArray.iterator(); priceIterator.hasNext(); ) {
                    String picStr = (String) priceIterator.next();
                    if (StringUtils.isNotBlank(picStr)) {
                        allEnjoyCategoryDTOList.add(picStr);
                        priceEnjoyCategoryDTOList.add(picStr);
                    }
                }
            }

            if (CollectionUtils.isNotEmpty(allEnjoyCategoryDTOList)) {
                enjoyMap.put("全部", allEnjoyCategoryDTOList);
            }
            if (CollectionUtils.isNotEmpty(envEnjoyCategoryDTOList)) {
                enjoyMap.put("环境", envEnjoyCategoryDTOList);
            }
            if (CollectionUtils.isNotEmpty(foodEnjoyCategoryDTOList)) {
                enjoyMap.put("商品", foodEnjoyCategoryDTOList);
            }
            if (CollectionUtils.isNotEmpty(priceEnjoyCategoryDTOList)) {
                enjoyMap.put("价目表", priceEnjoyCategoryDTOList);
            }
            enjoyEatDTO.setEnjoyMap(enjoyMap);

            list.add(enjoyEatDTO);
        }

        return list;
    }

    /**
     * 获取详情
     *
     * @param areaCode
     * @return
     */
    private EnjoyBaseDTO getEnjoyBaseDTO(String areaCode) {
        EnjoyBaseDTO enjoyBaseDTO = this.redisHashMapAdapter.get(this.getEnjoyEatListKey(), this.generateKeyByCodeAndType(areaCode),
                EnjoyBaseDTO.class);
        if (enjoyBaseDTO == null) {
            enjoyBaseDTO = getConvertEnjoyBaseDTO(areaCode);
            this.redisHashMapAdapter.put(this.getEnjoyEatListKey(), this.generateKeyByCodeAndType(areaCode), enjoyBaseDTO);
        }

        return enjoyBaseDTO;
    }

    /**
     * 转换数据， 从oss上获取的数据转化成本地需要的数据
     *
     * @param areaCode
     * @return
     */
    private EnjoyBaseDTO getConvertEnjoyBaseDTO(String areaCode) {
        EnjoyEatBaseDTO enjoyEatBaseDTO = readJsonFile(areaCode);
        EnjoyBaseDTO enjoyBaseDTO = new EnjoyBaseDTO();
        List<EnjoyDTO> enjoyList = Lists.newArrayList();
        enjoyEatBaseDTO.getEnjoyList().forEach(enjoyEatDTO -> {
            EnjoyDTO enjoyDTO = getAndSetEnjoyEatDTO(enjoyEatDTO);
            enjoyList.add(enjoyDTO);
        });
//        for (EnjoyEatDTO enjoyEatDTO : enjoyEatBaseDTO.getEnjoyList()) {
//            EnjoyDTO enjoyDTO = getAndSetEnjoyEatDTO(enjoyEatDTO);
//            enjoyList.add(enjoyDTO);
//        }
        enjoyBaseDTO.setEnjoyList(enjoyList);

        List<EnjoyDTO> eatList = Lists.newArrayList();
        enjoyEatBaseDTO.getEatList().forEach(enjoyEatDTO -> {
            EnjoyDTO enjoyDTO = getAndSetEnjoyEatDTO(enjoyEatDTO);
            eatList.add(enjoyDTO);
        });
//        for (EnjoyEatDTO enjoyEatDTO : enjoyEatBaseDTO.getEatList()) {
//            EnjoyDTO enjoyDTO = getAndSetEnjoyEatDTO(enjoyEatDTO);
//            eatList.add(enjoyDTO);
//        }
        enjoyBaseDTO.setEatList(eatList);

        return enjoyBaseDTO;
    }

    /**
     * 获取基础对象并设置对应对象的详情，enjoyDTO为基础对象 enjoyDetailDTO为详情对象
     *
     * @param enjoyEatDTO
     * @return
     */
    private EnjoyDTO getAndSetEnjoyEatDTO(EnjoyEatDTO enjoyEatDTO) {
        EnjoyDTO enjoyDTO = new EnjoyDTO();
        BeanUtils.copyProperties(enjoyEatDTO, enjoyDTO);

        EnjoyDetailDTO enjoyDetailDTO = enjoyEatDTO;
        this.redisStringAdapter.set(this.generateKeyById(enjoyDetailDTO.getId()), enjoyDetailDTO);
        return enjoyDTO;
    }

    /**
     * 远程读取网络文件
     *
     * @param url
     * @return
     */
    private String readFile(String url) {
        try {
            URL u = new URL(url);

            BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream()));

            String content = "";

            String inputLine = in.readLine();
            while (inputLine != null) {
                content += inputLine;
                inputLine = in.readLine();
            }
            in.close();
            return content;
        } catch (MalformedURLException e) {

            return null;
        } catch (IOException ioe) {
            return null;
        }
    }
}
