package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WxMpAuthService;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.service.UserAuthSupplyService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpUserService;
import me.chanjar.weixin.mp.api.impl.WxMpUserServiceImpl;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

/**
 * @author zhaoyadong 2018/10/17 16:43
 * @desc
 */
@Service
public class WxMpAuthServiceImpl extends BaseService implements WxMpAuthService {

    private UserAuthSupplyService userAuthSupplyService;

    private UserService userService;

    private WxMpService wxMpService;

    private WxMpUserService wxMpUserService;

    @Autowired
    public WxMpAuthServiceImpl(UserAuthSupplyService userAuthSupplyService, UserService userService,
                               WxMpService wxMpService) {
        this.userAuthSupplyService = userAuthSupplyService;
        this.userService = userService;
        this.wxMpService = wxMpService;
    }

    @PostConstruct
    public void init() {
        this.wxMpUserService = new WxMpUserServiceImpl(wxMpService);
    }

    @Override
    public WxUserInfo getUserByCode(String code) {
        WxUserInfo wxUserInfo = getWxUserInfoByCode(code);

        UserAuth userAuth = userAuthSupplyService.selectByUserAuth(wxUserInfo.getUnionId());
        if (null != userAuth) {
            wxUserInfo.setUserId(userAuth.getUserId());
            UserInfoDTO userInfoDTO = userService.getUserFromRedisDB(userAuth.getUserId());
            wxUserInfo.setToken(userInfoDTO.getToken());
        }

        return wxUserInfo;
    }

    @Override
    public WxMpUserList getUserList(String nextOpenId) {
        try {
            return wxMpUserService.userList(nextOpenId);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public WxMpUser getUser(String openId) {
        try {
            return wxMpUserService.userInfo(openId);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 通过code获取微信用户信息
     * @param code
     * @return
     */
    private WxUserInfo getWxUserInfoByCode(String code) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        if (StringUtils.isBlank(code)) {
            return wxUserInfo;
        }

        try {
            WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
            WxMpUser wxMpUser = wxMpService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
            wxUserInfo = convertWxMpUser(wxMpUser);
        } catch (WxErrorException e) {
            logger.error(e.getMessage(), e);
            return wxUserInfo;
        }

        return wxUserInfo;
    }

    /**
     * 获取的微信用户信息转换为自己所需要的用户信息
     * @param wxMpUser
     * @return
     */
    private WxUserInfo convertWxMpUser(WxMpUser wxMpUser) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        wxUserInfo.setOpenId(wxMpUser.getOpenId());
        //unionId主要是为了让app和公众号共用一个账号
        wxUserInfo.setUnionId(wxMpUser.getUnionId());
        wxUserInfo.setHeadImg(wxMpUser.getHeadImgUrl());
        if (StringUtils.isEmpty(wxMpUser.getHeadImgUrl())) {
            wxUserInfo.setHeadImg(userService.getDefaultHeadImgUrl());
        }
        wxUserInfo.setNickname(wxMpUser.getNickname());

        return wxUserInfo;
    }

    @Override
    public WxJsapiSignature getWxJsapiSignature(String url) {
        try {
            return wxMpService.createJsapiSignature(url);
        } catch (WxErrorException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }
}
