/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.dto.LocationFacadeDTO;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.constant.GlobalFlagEnum;
import com.bxm.localnews.thirdparty.domain.AdvertAreaMapper;
import com.bxm.localnews.thirdparty.domain.AdvertMapper;
import com.bxm.localnews.thirdparty.domain.AdvertPositionMapper;
import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.vo.Advert;
import com.bxm.localnews.thirdparty.vo.AdvertArea;
import com.bxm.localnews.thirdparty.vo.AdvertRecord;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertServiceImpl
implements AdvertService {
    private static final Logger LOG = LoggerFactory.getLogger(AdvertServiceImpl.class);
    private static final int AREA_CODE_LENGTH = 12;
    private AdvertMapper advertMapper;
    private AdvertAreaMapper advertAreaMapper;
    private RedisStringAdapter redisStringAdapter;
    private LocationFacadeService locationFacadeService;
    private AdvertPositionMapper advertPositionMapper;

    @Autowired
    public AdvertServiceImpl(AdvertMapper advertMapper, AdvertAreaMapper advertAreaMapper, RedisStringAdapter redisStringAdapter, LocationFacadeService locationFacadeService, AdvertPositionMapper advertPositionMapper) {
        this.advertMapper = advertMapper;
        this.advertAreaMapper = advertAreaMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.locationFacadeService = locationFacadeService;
        this.advertPositionMapper = advertPositionMapper;
    }

    private List<Advert> getAllAdvertByType(Byte type) {
        TypeReference<List<Advert>> typeReference = new TypeReference<List<Advert>>(){};
        List advertInfoList = (List)this.redisStringAdapter.get(this.getAdvertListKey(type), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)advertInfoList)) {
            advertInfoList = this.advertPositionMapper.getAdvertPositionListByType(Integer.valueOf(type.byteValue()), Integer.valueOf(1));
            LOG.info("\u83b7\u53d6\u5230\u7684\u5e7f\u544a\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)advertInfoList));
            if (CollectionUtils.isNotEmpty((Collection)advertInfoList)) {
                this.redisStringAdapter.set(this.getAdvertListKey(type), (Object)advertInfoList);
            }
        }
        return advertInfoList;
    }

    public List<AdvertDTO> queryAdByType(Byte type, String areaCode, Long userId) {
        List<Long> whiteAreaList = new ArrayList<Long>();
        List<Long> blackAreaList = new ArrayList<Long>();
        List<Advert> advertList = this.getAllAdvertByType(type);
        if (StringUtils.isNotBlank((CharSequence)areaCode)) {
            whiteAreaList = this.getAdvertArea(areaCode, 1);
            blackAreaList = this.getAdvertArea(areaCode, 2);
        }
        List<Object> advertDTOList = this.getAdvertDTOs(advertList, whiteAreaList, blackAreaList);
        advertDTOList = advertDTOList.stream().filter(advertDTO -> this.removeByPutTime((AdvertDTO)advertDTO)).collect(Collectors.toList());
        if (AdvertTypeEnum.SHOUYE_TANCH.getType().equals(String.valueOf(type))) {
            List<AdvertDTO> advertDTOS = this.filterAdvertInfo(userId, advertDTOList);
            return advertDTOS;
        }
        if (userId != null && CollectionUtils.isNotEmpty(advertDTOList)) {
            this.recordAdvert(userId, advertDTOList);
        }
        return advertDTOList;
    }

    private Boolean removeByPutTime(AdvertDTO advertDTO) {
        Date now = new Date();
        return !(advertDTO.getStartTime() != null && DateUtils.after((Date)advertDTO.getStartTime(), (Date)now) || advertDTO.getEndTime() != null && DateUtils.before((Date)advertDTO.getEndTime(), (Date)now));
    }

    private void recordAdvert(Long userId, List<AdvertDTO> advertDTOList) {
        ArrayList advertRecords = Lists.newArrayList();
        Date now = new Date();
        advertDTOList.forEach(advertDTO -> {
            AdvertRecord advertRecord = new AdvertRecord();
            advertRecord.setAdvertId(advertDTO.getId());
            advertRecord.setUserId(userId);
            advertRecord.setViewTime(now);
            advertRecords.add(advertRecord);
        });
        if (CollectionUtils.isEmpty((Collection)advertRecords)) {
            return;
        }
        this.advertMapper.recordAdvert((List)advertRecords);
    }

    public Advert selectByPrimaryKey(Long id) {
        return this.advertMapper.selectByPrimaryKey(id);
    }

    public List<AdvertDTO> getListAds(int size) {
        return this.advertMapper.getListAds(Integer.valueOf(size));
    }

    private List<AdvertDTO> getAdvertDTOs(List<Advert> advertList, List<Long> whiteAreaList, List<Long> blackAreaList) {
        ArrayList advertDTOList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(advertList)) {
            for (Advert advert : advertList) {
                if (GlobalFlagEnum.IS_NOT_GLOBAL.getState().equals(advert.getGlobalFlag()) && !whiteAreaList.contains(advert.getId()) || GlobalFlagEnum.IS_GLOBAL.getState().equals(advert.getGlobalFlag()) && blackAreaList.contains(advert.getId())) continue;
                AdvertDTO advertDTO = this.getAdvertDTOByAdvert(advert);
                advertDTOList.add(advertDTO);
            }
        }
        return advertDTOList;
    }

    private KeyGenerator getAdvertListKey(Byte type) {
        return RedisConfig.THIRDPARTY_TYPE_ADVERT.copy().appendKey((Object)type).appendKey((Object)"list");
    }

    private AdvertDTO getAdvertDTOByAdvert(Advert advert) {
        AdvertDTO advertDTO = new AdvertDTO();
        BeanUtils.copyProperties((Object)advert, (Object)advertDTO);
        return advertDTO;
    }

    private List<Long> getAdvertAreasByAreaCode(String areaCode) {
        areaCode = this.complteAreaCode(areaCode);
        return this.advertAreaMapper.getAllAdvertAreaByAreaCode(areaCode).stream().map(AdvertArea::getAdvertId).collect(Collectors.toList());
    }

    private List<Long> getAdvertArea(String areaCode, Integer areaType) {
        areaCode = this.complteAreaCode(areaCode);
        return this.advertAreaMapper.getAllAdvertAreaByAreaCodeAndType(areaCode, areaType).stream().map(AdvertArea::getAdvertId).collect(Collectors.toList());
    }

    private String complteAreaCode(String areaCode) {
        LocationFacadeDTO locationDTO;
        String fullCode = areaCode;
        if (12 != fullCode.length() && null == (locationDTO = this.locationFacadeService.getLocationByCode(fullCode = areaCode + "000000"))) {
            fullCode = areaCode.substring(0, 4) + "00000000";
        }
        return fullCode;
    }

    private List<AdvertDTO> filterAdvertInfo(Long userId, List<AdvertDTO> list) {
        List<Object> advertDTOS = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return advertDTOS;
        }
        advertDTOS = list.stream().filter(advertDTO -> this.checkRemoveAdvertInfo(userId, advertDTO.getId(), advertDTO.getShowType()) == false).collect(Collectors.toList());
        return advertDTOS;
    }

    private Boolean checkRemoveAdvertInfo(Long userId, Long advertId, Byte showType) {
        if (this.redisStringAdapter.hasKey(this.getAdvertByTypeKey(showType, userId, advertId)).booleanValue()) {
            return true;
        }
        if (showType != null) {
            if (showType == 3) {
                this.redisStringAdapter.set(this.getAdvertByTypeKey(showType, userId, advertId), (Object)userId, (long)DateUtils.getCurSeconds());
            } else {
                this.redisStringAdapter.set(this.getAdvertByTypeKey(showType, userId, advertId), (Object)userId);
            }
        }
        return false;
    }

    private KeyGenerator getAdvertByTypeKey(Byte showType, Long userId, Long advertId) {
        return RedisConfig.THIRDPARTY_SHOW_TYPE_ADVERT.copy().appendKey((Object)(advertId + "_" + showType + "_" + userId));
    }
}

