/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.constant.EnjoyTypeEnum;
import com.bxm.localnews.thirdparty.dto.EnjoyBaseDTO;
import com.bxm.localnews.thirdparty.dto.EnjoyDTO;
import com.bxm.localnews.thirdparty.dto.EnjoyDetailDTO;
import com.bxm.localnews.thirdparty.dto.EnjoyEatBaseDTO;
import com.bxm.localnews.thirdparty.dto.EnjoyEatDTO;
import com.bxm.localnews.thirdparty.service.EnjoyEatService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnjoyEatServieImpl
extends BaseService
implements EnjoyEatService {
    private RedisHashMapAdapter redisHashMapAdapter;
    private RedisStringAdapter redisStringAdapter;
    private SequenceCreater sequenceCreater;

    @Autowired
    public EnjoyEatServieImpl(RedisHashMapAdapter redisHashMapAdapter, SequenceCreater sequenceCreater, RedisStringAdapter redisStringAdapter) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.sequenceCreater = sequenceCreater;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public EnjoyBaseDTO getEnjoyBaseDTOByCode(String areaCode) {
        EnjoyBaseDTO enjoyBaseDTO = this.getEnjoyBaseDTO(areaCode);
        return enjoyBaseDTO;
    }

    @Override
    public EnjoyDetailDTO getEnjoyDetailDTO(Long id) {
        return (EnjoyDetailDTO)this.redisStringAdapter.get(this.generateKeyById(id), EnjoyDetailDTO.class);
    }

    private KeyGenerator getEnjoyEatListKey() {
        return RedisConfig.THIRDPARTY_ENJOY_EAT.copy().appendKey((Object)"list");
    }

    private String generateKeyByCodeAndType(String areaCode, Byte type) {
        return areaCode + "_" + type;
    }

    private KeyGenerator generateKeyById(Long id) {
        return RedisConfig.THIRDPARTY_ENJOY_EAT.copy().appendKey((Object)id);
    }

    private String generateKeyByCodeAndType(String areaCode) {
        return areaCode;
    }

    private String getOSSUrlByCodeAndType(String areaCode, Byte type) {
        String genUrl = "https://bxm-news.oss-cn-hangzhou.aliyuncs.com/localnews_prod/enjoy_eat/";
        return genUrl + this.generateKeyByCodeAndType(areaCode, type) + ".json";
    }

    private EnjoyEatBaseDTO readJsonFile(String areaCode) {
        String url = this.getOSSUrlByCodeAndType(areaCode, EnjoyTypeEnum.ENJOY.getType());
        EnjoyEatBaseDTO enjoyEatBaseDTO = new EnjoyEatBaseDTO();
        enjoyEatBaseDTO.setEatList(this.getEnjoyEatList(this.readFile(url)));
        url = this.getOSSUrlByCodeAndType(areaCode, EnjoyTypeEnum.EAT.getType());
        enjoyEatBaseDTO.setEnjoyList(this.getEnjoyEatList(this.readFile(url)));
        return enjoyEatBaseDTO;
    }

    private List<EnjoyEatDTO> getEnjoyEatList(String url) {
        ArrayList list = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)url)) {
            return list;
        }
        JSONArray jsonArray = JSONObject.parseArray((String)url);
        for (JSONObject jsonObject : jsonArray) {
            JSONArray priceJsonArray;
            EnjoyEatDTO enjoyEatDTO = new EnjoyEatDTO();
            enjoyEatDTO.setId(this.sequenceCreater.nextLongId());
            enjoyEatDTO.setType(EnjoyTypeEnum.ENJOY.getType());
            String name = jsonObject.getString("title");
            enjoyEatDTO.setName(name);
            String imgUrl = jsonObject.getString("main_pic");
            enjoyEatDTO.setUrl(imgUrl);
            String time = jsonObject.getString("time");
            enjoyEatDTO.setBusinessTime(time);
            String address = jsonObject.getString("address");
            enjoyEatDTO.setAddress(address);
            String phone = jsonObject.getString("tel");
            enjoyEatDTO.setPhone(phone);
            LinkedHashMap enjoyMap = Maps.newLinkedHashMap();
            ArrayList recommondList = Lists.newArrayList();
            ArrayList allEnjoyCategoryDTOList = Lists.newArrayList();
            ArrayList envEnjoyCategoryDTOList = Lists.newArrayList();
            ArrayList foodEnjoyCategoryDTOList = Lists.newArrayList();
            ArrayList priceEnjoyCategoryDTOList = Lists.newArrayList();
            JSONArray foodJsonArray = jsonObject.getJSONArray("shop_food_msg");
            if (CollectionUtils.isNotEmpty((Collection)foodJsonArray)) {
                for (JSONObject foodJsonObject : foodJsonArray) {
                    String pic;
                    String foodName = foodJsonObject.getString("name");
                    if (StringUtils.isNotBlank((CharSequence)foodName)) {
                        recommondList.add(foodName);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(pic = foodJsonObject.getString("pic")))) continue;
                    allEnjoyCategoryDTOList.add(pic);
                    foodEnjoyCategoryDTOList.add(pic);
                }
            }
            enjoyEatDTO.setRecommondFood((List)recommondList);
            JSONArray envJsonArray = jsonObject.getJSONArray("shop_pic_env");
            if (CollectionUtils.isNotEmpty((Collection)envJsonArray)) {
                for (String picStr : envJsonArray) {
                    if (!StringUtils.isNotBlank((CharSequence)picStr)) continue;
                    allEnjoyCategoryDTOList.add(picStr);
                    envEnjoyCategoryDTOList.add(picStr);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(priceJsonArray = jsonObject.getJSONArray("shop_pic_price")))) {
                for (String picStr : priceJsonArray) {
                    if (!StringUtils.isNotBlank((CharSequence)picStr)) continue;
                    allEnjoyCategoryDTOList.add(picStr);
                    priceEnjoyCategoryDTOList.add(picStr);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)allEnjoyCategoryDTOList)) {
                enjoyMap.put("\u5168\u90e8", allEnjoyCategoryDTOList);
            }
            if (CollectionUtils.isNotEmpty((Collection)envEnjoyCategoryDTOList)) {
                enjoyMap.put("\u73af\u5883", envEnjoyCategoryDTOList);
            }
            if (CollectionUtils.isNotEmpty((Collection)foodEnjoyCategoryDTOList)) {
                enjoyMap.put("\u5546\u54c1", foodEnjoyCategoryDTOList);
            }
            if (CollectionUtils.isNotEmpty((Collection)priceEnjoyCategoryDTOList)) {
                enjoyMap.put("\u4ef7\u76ee\u8868", priceEnjoyCategoryDTOList);
            }
            enjoyEatDTO.setEnjoyMap(enjoyMap);
            list.add(enjoyEatDTO);
        }
        return list;
    }

    private EnjoyBaseDTO getEnjoyBaseDTO(String areaCode) {
        EnjoyBaseDTO enjoyBaseDTO = (EnjoyBaseDTO)this.redisHashMapAdapter.get(this.getEnjoyEatListKey(), this.generateKeyByCodeAndType(areaCode), EnjoyBaseDTO.class);
        if (enjoyBaseDTO == null) {
            enjoyBaseDTO = this.getConvertEnjoyBaseDTO(areaCode);
            this.redisHashMapAdapter.put(this.getEnjoyEatListKey(), this.generateKeyByCodeAndType(areaCode), (Object)enjoyBaseDTO);
        }
        return enjoyBaseDTO;
    }

    private EnjoyBaseDTO getConvertEnjoyBaseDTO(String areaCode) {
        EnjoyEatBaseDTO enjoyEatBaseDTO = this.readJsonFile(areaCode);
        EnjoyBaseDTO enjoyBaseDTO = new EnjoyBaseDTO();
        ArrayList enjoyList = Lists.newArrayList();
        enjoyEatBaseDTO.getEnjoyList().forEach(enjoyEatDTO -> {
            EnjoyDTO enjoyDTO = this.getAndSetEnjoyEatDTO((EnjoyEatDTO)enjoyEatDTO);
            enjoyList.add(enjoyDTO);
        });
        enjoyBaseDTO.setEnjoyList((List)enjoyList);
        ArrayList eatList = Lists.newArrayList();
        enjoyEatBaseDTO.getEatList().forEach(enjoyEatDTO -> {
            EnjoyDTO enjoyDTO = this.getAndSetEnjoyEatDTO((EnjoyEatDTO)enjoyEatDTO);
            eatList.add(enjoyDTO);
        });
        enjoyBaseDTO.setEatList((List)eatList);
        return enjoyBaseDTO;
    }

    private EnjoyDTO getAndSetEnjoyEatDTO(EnjoyEatDTO enjoyEatDTO) {
        EnjoyDTO enjoyDTO = new EnjoyDTO();
        BeanUtils.copyProperties((Object)enjoyEatDTO, (Object)enjoyDTO);
        EnjoyEatDTO enjoyDetailDTO = enjoyEatDTO;
        this.redisStringAdapter.set(this.generateKeyById(enjoyDetailDTO.getId()), (Object)enjoyDetailDTO);
        return enjoyDTO;
    }

    private String readFile(String url) {
        try {
            URL u = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream()));
            String content = "";
            String inputLine = in.readLine();
            while (inputLine != null) {
                content = content + inputLine;
                inputLine = in.readLine();
            }
            in.close();
            return content;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

