/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.thirdparty.config.WechatProperties;
import com.bxm.localnews.thirdparty.service.PushMessageService;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushMessageServiceImpl
implements PushMessageService {
    private Logger LOG = LoggerFactory.getLogger(PushMessageServiceImpl.class);
    private static final String WE_CHAT_PUSH_URL = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send";
    @Autowired
    private WechatService wechatService;
    @Autowired
    private WechatProperties wechatProperties;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private HttpClientService httpClientService;
    @Autowired
    private UserAuthIntegrationService userAuthIntegrationService;

    public void pushMessage(BigDecimal cash, Long userId) {
        if (null == userId || null == cash) {
            return;
        }
        UserAuth userAuth = this.userAuthIntegrationService.selectAppletUserAuthByUserId(userId);
        if (null == userAuth) {
            return;
        }
        KeyGenerator key = RedisConfig.WEIXIN_FORMID.copy().appendKey((Object)userId);
        String userFormId = (String)this.redisStringAdapter.get(key, String.class);
        if (userFormId == null) {
            return;
        }
        JSONObject data = new JSONObject();
        JSONObject keyword1 = new JSONObject();
        JSONObject keyword2 = new JSONObject();
        keyword1.put("value", (Object)("\u5165\u8d26" + cash.stripTrailingZeros().toPlainString() + "\u5143"));
        keyword2.put("value", (Object)"\u5206\u4eab\u8d8a\u591a\u5956\u91d1\u8d8a\u591a\uff0c\u70b9\u51fb\u53bb\u63d0\u73b0");
        data.put("keyword1", (Object)keyword1);
        data.put("keyword2", (Object)keyword2);
        JSONObject parameters = new JSONObject();
        parameters.put("access_token", (Object)this.wechatService.getWeChatToken());
        parameters.put("touser", (Object)userAuth.getIdentifier());
        parameters.put("template_id", (Object)this.wechatProperties.getTemplateId());
        parameters.put("form_id", (Object)userFormId);
        parameters.put("data", (Object)data);
        parameters.put("emphasis_keyword", (Object)"keyword1.DATA");
        String page = this.wechatProperties.getPushPage();
        if (!page.endsWith("?")) {
            page = page + "?";
        }
        page = page + "inviteUserId=";
        parameters.put("page", (Object)page);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("weChat push params:{}", (Object)parameters);
        }
        try {
            JSONObject result = JSON.parseObject((String)this.httpClientService.doPostJson("https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token=" + this.wechatService.getWeChatToken(), parameters.toJSONString()));
            this.LOG.info("weChat push result:{}", (Object)result.toJSONString());
        }
        catch (Exception e) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.info("weChat push error", (Throwable)e);
            }
            return;
        }
    }
}

