/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WxMpAuthService;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import javax.annotation.PostConstruct;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpUserService;
import me.chanjar.weixin.mp.api.impl.WxMpUserServiceImpl;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxMpAuthServiceImpl
extends BaseService
implements WxMpAuthService {
    private UserAuthIntegrationService userAuthIntegrationService;
    private UserIntegrationService userIntegrationService;
    private WxMpService wxMpService;
    private WxMpUserService wxMpUserService;

    @Autowired
    public WxMpAuthServiceImpl(UserAuthIntegrationService userAuthIntegrationService, UserIntegrationService userIntegrationService, WxMpService wxMpService) {
        this.userAuthIntegrationService = userAuthIntegrationService;
        this.userIntegrationService = userIntegrationService;
        this.wxMpService = wxMpService;
    }

    @PostConstruct
    public void init() {
        this.wxMpUserService = new WxMpUserServiceImpl(this.wxMpService);
    }

    @Override
    public WxUserInfo getUserByCode(String code) {
        WxUserInfo wxUserInfo = this.getWxUserInfoByCode(code);
        UserAuth userAuth = this.userAuthIntegrationService.selectUserAuthByUnionId(wxUserInfo.getUnionId());
        if (null != userAuth) {
            wxUserInfo.setUserId(userAuth.getUserId());
            UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userAuth.getUserId());
            wxUserInfo.setToken(userInfoDTO.getToken());
        }
        return wxUserInfo;
    }

    @Override
    public WxMpUserList getUserList(String nextOpenId) {
        try {
            return this.wxMpUserService.userList(nextOpenId);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public WxMpUser getUser(String openId) {
        try {
            return this.wxMpUserService.userInfo(openId);
        }
        catch (Exception e) {
            return null;
        }
    }

    private WxUserInfo getWxUserInfoByCode(String code) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        if (StringUtils.isBlank((CharSequence)code)) {
            return wxUserInfo;
        }
        try {
            WxMpOAuth2AccessToken wxMpOAuth2AccessToken = this.wxMpService.oauth2getAccessToken(code);
            WxMpUser wxMpUser = this.wxMpService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
            wxUserInfo = this.convertWxMpUser(wxMpUser);
        }
        catch (WxErrorException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return wxUserInfo;
        }
        return wxUserInfo;
    }

    private WxUserInfo convertWxMpUser(WxMpUser wxMpUser) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        wxUserInfo.setOpenId(wxMpUser.getOpenId());
        wxUserInfo.setUnionId(wxMpUser.getUnionId());
        wxUserInfo.setHeadImg(wxMpUser.getHeadImgUrl());
        if (StringUtils.isEmpty((CharSequence)wxMpUser.getHeadImgUrl())) {
            wxUserInfo.setHeadImg(this.userIntegrationService.getDefaultHeadImgUrl());
        }
        wxUserInfo.setNickname(wxMpUser.getNickname());
        return wxUserInfo;
    }

    @Override
    public WxJsapiSignature getWxJsapiSignature(String url) {
        try {
            return this.wxMpService.createJsapiSignature(url);
        }
        catch (WxErrorException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

