package com.bxm.localnews.thirdparty.advert;

import com.bxm.localnews.thirdparty.param.AiqiyiAdvertCallbackParam;
import com.bxm.localnews.thirdparty.param.BaiduAdvertCallbackParam;

/**
 * 广告回调服务，主要用于第三方广告接入
 * os：安卓接入SDK失败，不得不采用服务端接入API的方式
 * @author liujia
 */
public interface AdvertCallbackService {

    /**
     * 百度请求回调
     * @param param 请求参数
     */
    void baiduCallback(BaiduAdvertCallbackParam param);

    /**
     * 爱奇艺广告触发
     * @param param 请求参数
     */
    void aiqiyiCallback(AiqiyiAdvertCallbackParam param);

    /**
     * 触发回调，用户完成注册后，判断是否存在对应的用户
     * @param androidId 用户的安卓ID
     * @return
     */
    boolean triggerCallback(String androidId);
}
