package com.bxm.localnews.thirdparty.advert.annotation;


import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import org.springframework.stereotype.Component;

import java.lang.annotation.*;

/**
 * 广告过滤器定义
 *
 * @author Gonzo
 * @date 2019-08-21 10:08
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Component
public @interface AdverFilter {

    /**
     * 当前filter支持过滤的position，默认支持所有
     *
     * @return 广告过滤器匹配的广告位
     */
    AdvertTypeEnum[] value() default {};
}
