package com.bxm.localnews.thirdparty.config;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * KfcProperty
 *
 * @author xuyanjun
 * @date 2020/4/10
 */
@Getter
@Setter
@ToString
@ConfigurationProperties(prefix = "thirdparty.config.kfc")
@Component
public class KfcProperty {

    /**
     * 平台id
     * 10264 测试
     */
    private Integer platformId = 10264;

    /**
     * 密钥
     * 52j9brvppzu3l1ls 测试
     */
    private String secret = "52j9brvppzu3l1ls";

    /**
     * 服务器地址
     * https://live-test.qianzhu8.com 测试
     * https://live.qianzhu8.com 正式
     */
    private String serverUrl = "https://live-test.qianzhu8.com";

    /**
     * 页面的域名
     */
    private String pageUrl = "https://kfc.qianzhu8.com";

    /**
     * 连接超时时间(毫秒)
     */
    private Integer timeout = 10000;
}
