package com.bxm.localnews.thirdparty.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;

/**
 * @author gonzo
 * @date 2020-08-22 11:26
 **/
@Data
@Component
@ConfigurationProperties("thirdparty.config.popup")
public class PopupProperties {

    /**
     * 普通用户引导弹窗title
     */
    private String normalNoviceUserGuideTitle = "圈友们终于等到你\n欢迎你加入%s万事通";

    /**
     * 普通用户引导弹窗content
     */
    private String normalNoviceUserGuideContent = "先跟大家打个招呼吧";

    /**
     * vip用户引导弹窗content
     */
    private String vipNoviceUserGuideContent = "送你一张%s万事通VIP卡";

    /**
     * 普通用户的引导私聊消息
     */
    private List<String> normalNoviceUserGuideSentMsgContents = Arrays.asList(
            "hello，我通过你的邀请成功加入%s万事通了，感谢啦",
            "终于来到%s万事通了，感谢你的邀请",
            "%s万事通我已经注册好了，感谢你的邀请",
            "谢谢你的邀请，我终于加入到%s万事通了",
            "感谢邀请，初次来到%s万事通，请多指教"
            );

    /**
     * 默认的 普通用户的引导私聊消息
     */
    private String defaultNormalNoviceUserGuideSentMsgContent = "你好，感谢你的邀请，我终于来到万事通啦~";


    /**
     * vip用户的引导私聊消息
     */
    private List<String> vipNoviceUserGuideSentMsgContents = Arrays.asList("感谢你赠送的邀请码哦",
            "我已经收到你赠送vip啦，以后可以在万事通上买买买了",
            "这个万事通vip感觉还不错呢，感谢你的赠送",
            "我已经成功激活万事通vip啦",
            "开通万事通vip了，感谢你的邀请",
            "嗯，万事通vip卡我已经开通了，谢谢",
            "vip已经收入囊中，感谢你哦"
            );

    /**
     * 新人报道话题id 测试环境 92874170306688
     */
    private Long noviceTopicId;

    /**
     * 插屏广告弹窗开关
     * false: 关闭
     */
    private Boolean thrustAdvertPopSwitch = Boolean.FALSE;

    /**
     * 万事通客服头像
     */
    private String serverHeadImg = "https://m.wstong.com/localnews_prod/jpg/20191023/037eddb89ca56186-20191023171849645--1.jpg?x-oss-process=style/mcompress";
}
