package com.bxm.localnews.thirdparty.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@Data
@ConfigurationProperties("thirdparty.config")
public class ThirdPartyProperties {

    /**
     * 设备验证token
     */
    private String machineToken;

    /**
     * 设备接入码
     */
    private String machineEncodingAESKey;

    /**
     * 机器对应的appid
     */
    private String machineAppId;

    /**
     * 显示app弹窗广告
     */
    private boolean showPopAdvert;

    /**
     * 百度的广告安卓投放key
     */
    private String baiduAndroidKey;

    /**
     * 爱奇艺的广告安卓投放key
     */
    private String aiqiyiAndroidKey;
}
