package com.bxm.localnews.thirdparty.config;

import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.thirdparty.dto.WechatMP;
import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 微信公众号授权配置
 * @author Gonzo
 * @date 2019-12-18 16:29
 */
@Component
@ConfigurationProperties(prefix = "thirdparty.config.wechat.mp.auth")
@Data
public class WechatMPAuthConfig {

    /**
     * 微信授权的H5路径
     * key: 授权类型 WECHAT_AUTH: 站外微信用户授权中间页 WECHAT_PAY: 站外微信支付中间页
     */
    private Map<String, String> authPath = Maps.newHashMap();
}
