package com.bxm.localnews.thirdparty.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaKefuMessage;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.bean.WxMaTemplateData;
import cn.binarywang.wx.miniapp.bean.WxMaTemplateMessage;
import cn.binarywang.wx.miniapp.message.WxMaMessageHandler;
import cn.binarywang.wx.miniapp.message.WxMaMessageRouter;
import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriUtils;

import javax.annotation.PostConstruct;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhaoyadong 2019/5/23 17:18
 * @desc
 */
@Configuration
@EnableConfigurationProperties(WxMaProperties.class)
public class WxMaConfiguration {

    private WxMaProperties properties;

    private RedisStringAdapter redisStringAdapter;

    private WxPortalCustomerProperties wxPortalCustomerProperties;

    private BaseUrlFacadeService baseUrlFacadeService;

    private CustomApacheHttpClientBuilder customApacheHttpClientBuilder;

    private static Map<String, WxMaMessageRouter> routers = Maps.newHashMap();

    private static Map<String, WxMaService> maServices = Maps.newHashMap();

    private static final Logger LOGGER = LoggerFactory.getLogger(WxMaConfiguration.class);

    public WxMaConfiguration(WxMaProperties properties, RedisStringAdapter redisStringAdapter,
                             WxPortalCustomerProperties wxPortalCustomerProperties, BaseUrlFacadeService baseUrlFacadeService,
                             CustomApacheHttpClientBuilder customApacheHttpClientBuilder) {
        this.properties = properties;
        this.redisStringAdapter = redisStringAdapter;
        this.wxPortalCustomerProperties = wxPortalCustomerProperties;
        this.baseUrlFacadeService = baseUrlFacadeService;
        this.customApacheHttpClientBuilder = customApacheHttpClientBuilder;
    }

    //    private static Map<String, String> customerUrl = Maps.newHashMap();

    private final WxMaMessageHandler templateMsgHandler = (wxMessage, context, service, sessionManager) ->
            service.getMsgService().sendTemplateMsg(WxMaTemplateMessage.builder()
                    .templateId("此处更换为自己的模板id")
                    .formId("自己替换可用的formid")
                    .data(Lists.newArrayList(
                            new WxMaTemplateData("keyword1", "339208499", "#173177")))
                    .toUser(wxMessage.getFromUser())
                    .build());

    private final WxMaMessageHandler logHandler = (wxMessage, context, service, sessionManager) -> {
        LOGGER.info("收到消息：[{}]", wxMessage.toString());
    };

    private final WxMaMessageHandler picHandler = (wxMessage, context, service, sessionManager) -> {
        try {
            WxMediaUploadResult uploadResult = service.getMediaService()
                    .uploadMedia("image", "png",
                            ClassLoader.getSystemResourceAsStream("tmp.png"));
            service.getMsgService().sendKefuMsg(
                    WxMaKefuMessage
                            .newImageBuilder()
                            .mediaId(uploadResult.getMediaId())
                            .toUser(wxMessage.getFromUser())
                            .build());
        } catch (WxErrorException e) {
            e.printStackTrace();
        }
    };

    private final WxMaMessageHandler qrcodeHandler = (wxMessage, context, service, sessionManager) -> {
        try {
            final File file = service.getQrcodeService().createQrcode("123", 430);
            WxMediaUploadResult uploadResult = service.getMediaService().uploadMedia("image", file);
            service.getMsgService().sendKefuMsg(
                    WxMaKefuMessage
                            .newImageBuilder()
                            .mediaId(uploadResult.getMediaId())
                            .toUser(wxMessage.getFromUser())
                            .build());
        } catch (WxErrorException e) {
            e.printStackTrace();
        }
    };

    private final WxMaMessageHandler textHandler = (wxMessage, context, service, sessionManager) -> {
        LOGGER.info("收到的消息：[{}]", wxMessage.toString());

        String content = "";
        String url = "";

        if ("联系官方客服".equals(wxMessage.getTitle())) {
            LOGGER.debug("发送官方客服图片消息");
            content = "请点击下方的微信二维码，然后长按识别，添加我为微信好友哦~";
            url = wxPortalCustomerProperties.getOfficeCustomerUrl();
        } else if ("联系在线客服".equals(wxMessage.getTitle())) {
            content = "请点击下方的微信二维码，然后长按识别，添加我为微信好友哦~";
            LOGGER.debug("发送在线客服图片消息");
            url = wxPortalCustomerProperties.getOnlineCustomerUrl();
        } else if ("邀请你进入家乡群".equals(wxMessage.getTitle())) {
            LOGGER.debug("发送家乡群图片消息");
            content = "请点击下方的微信二维码，然后长按识别，添加微信好友后，我拉你进群哦~";
            url = wxPortalCustomerProperties.getHometownUrl();
        } else if ("本地万事通官方公众号".equals(wxMessage.getTitle())) {
            LOGGER.debug("发送微信公众号图片消息");
            content = "请长按识别下面的二维码图片，关注本地万事通公众号，即可领取小红花啦!";
            url = wxPortalCustomerProperties.getOfficeWechatUrl();
        } else if ("发布本地爆料领现金奖励哦".equals(wxMessage.getTitle()) || "去发布".equals(wxMessage.getTitle())) {
            LOGGER.debug("用户点击去发帖按钮");
            sendDownloadApp("点击链接下载App去发布哦~",
                    "立即下载",
                    buildDownloadUrl("applet-post"),
                    "点击下方链接下载本地万事通App去发布",
                    service,
                    wxMessage);
            return;
        } else if ("下载领红包".equals(wxMessage.getTitle())) {
            LOGGER.debug("用户点击下载领红包按钮");

            sendDownloadApp("点击下载App领红包！",
                    "手慢无，快抢",
                    buildDownloadUrl("applet-rp"),
                    "点击下方链接下载本地万事通App，马上领红包",
                    service,
                    wxMessage);
            return;
        }

        LOGGER.info("content:[{}],url:[{}]", content, url);

        if (StringUtils.isNotEmpty(url)) {
            WxMediaUploadResult uploadResult = service.getMediaService()
                    .uploadMedia("image", "png",
                            getInputStreamByUrl(url));
            service.getMsgService().sendKefuMsg(WxMaKefuMessage.newTextBuilder().content(content)
                    .toUser(wxMessage.getFromUser()).build());

            service.getMsgService().sendKefuMsg(
                    WxMaKefuMessage
                            .newImageBuilder()
                            .mediaId(uploadResult.getMediaId())
                            .toUser(wxMessage.getFromUser())
                            .build());
        }

    };

    private String buildDownloadUrl(String source) {
        String downloadUrl = baseUrlFacadeService.getDownloadYYBUrl();

        if (downloadUrl.contains("?")) {
            downloadUrl += "&source=" + source;
        } else {
            downloadUrl += "?source=" + source;
        }

        return downloadUrl;
    }

    private void sendDownloadApp(String title, String desc, String url, String content,
                                 WxMaService service, WxMaMessage wxMessage) throws WxErrorException {
        service.getMsgService().sendKefuMsg(
                WxMaKefuMessage.newTextBuilder()
                        .content(content)
                        .toUser(wxMessage.getFromUser())
                        .build());

//        service.getMsgService().sendKefuMsg(
//                WxMaKefuMessage.newTextBuilder()
//                        .content(url)
//                        .toUser(wxMessage.getFromUser())
//                        .build());

        service.getMsgService().sendKefuMsg(
                WxMaKefuMessage.newLinkBuilder()
                        .url(url)
                        .thumbUrl(baseUrlFacadeService.getAppIconUrl())
                        .title(title)
                        .description(desc)
                        .toUser(wxMessage.getFromUser())
                        .build());
    }

    public static Map<String, WxMaMessageRouter> getRouters() {
        return routers;
    }

    public static WxMaService getMaService(String appid) {
        WxMaService wxService = maServices.get(appid);
        if (wxService == null) {
            throw new IllegalArgumentException(String.format("未找到对应appid=[%s]的配置，请核实！", appid));
        }

        return wxService;
    }

    @PostConstruct
    public void init() {
        List<WxMaProperties.Config> configs = this.properties.getConfigs();
        if (configs == null) {
            throw new RuntimeException("小程序请添加相关配置，注意别配错了！");
        }

        maServices = configs.stream()
                .map(config -> {
                    WxMaService service = new WxMaServiceImpl();
                    service.setWxMaConfig(setConfig(config));
                    routers.put(config.getAppid(), this.newRouter(service));
                    return service;
                }).collect(Collectors.toMap(s -> s.getWxMaConfig().getAppid(), a -> a));
    }

    private WxMaInRedisConfig setConfig(WxMaProperties.Config config) {
        WxMaInRedisConfig wxMaInRedisConfig = new WxMaInRedisConfig(redisStringAdapter, customApacheHttpClientBuilder);
        wxMaInRedisConfig.setAppid(config.getAppid());
        wxMaInRedisConfig.setSecret(config.getSecret());
        wxMaInRedisConfig.setToken(config.getToken());
        wxMaInRedisConfig.setAesKey(config.getAesKey());
        wxMaInRedisConfig.setMsgDataFormat(config.getMsgDataFormat());
        return wxMaInRedisConfig;
    }

    private WxMaMessageRouter newRouter(WxMaService service) {
        final WxMaMessageRouter router = new WxMaMessageRouter(service);
        router
                .rule().handler(logHandler).next()
                .rule().async(false).content("模板").handler(templateMsgHandler).end()
                .rule().async(false).content("文本").handler(textHandler).end()
                .rule().async(false).content("图片").handler(picHandler).end()
                .rule().async(false).content("二维码").handler(qrcodeHandler).end();
        return router;
    }

    /**
     * 获取远端图片
     * @param imageUrl
     * @return
     */
    private InputStream getInputStreamByUrl(String imageUrl) {
        InputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            URL url = new URL(UriUtils.encodePath(imageUrl, "UTF-8"));
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestProperty("Content-Type", "plain/text;charset=" + "UTF-8");
            conn.setRequestProperty("charset", "UTF-8");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            conn.setReadTimeout(20000);
            conn.connect();

            return conn.getInputStream();
        } catch (IOException e) {
            LOGGER.error("发起请求出现异常:", e);
            return null;
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    LOGGER.error("【关闭流异常】");
                }
            }
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    LOGGER.error("【关闭流异常】");
                }
            }
        }
    }
}
