package com.bxm.localnews.thirdparty.config;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;

import cn.binarywang.wx.miniapp.config.WxMaInMemoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author zhaoyadong 2019/5/24 10:28
 * @desc
 */
public class WxMaInRedisConfig extends WxMaInMemoryConfig {

    private static final String ACCESS_TOKEN_KEY = "wechat_applet_access_token_";

    private static final String JSAPI_TICKET_KEY = "wechat_applet_jsapi_ticket_";

    private static final String CARDAPI_TICKET_KEY = "wechat_applet_cardapi_ticket_";

    private final static Logger logger = LoggerFactory.getLogger(WxMaInRedisConfig.class);

    private RedisStringAdapter redisStringAdapter;

    private String accessTokenKey;

    private String jsapiTicketKey;

    private String cardapiTicketKey;

    private CustomApacheHttpClientBuilder customApacheHttpClientBuilder;


    public WxMaInRedisConfig(RedisStringAdapter redisStringAdapter,CustomApacheHttpClientBuilder customApacheHttpClientBuilder) {
        this.redisStringAdapter = redisStringAdapter;
        this.customApacheHttpClientBuilder = customApacheHttpClientBuilder;
        setApacheHttpClientBuilder(customApacheHttpClientBuilder);
    }

    @Override
    public void setAppid(String appId) {
        super.setAppid(appId);
        this.accessTokenKey = ACCESS_TOKEN_KEY.concat(appId);
        this.jsapiTicketKey = JSAPI_TICKET_KEY.concat(appId);
        this.cardapiTicketKey = CARDAPI_TICKET_KEY.concat(appId);
    }

    private KeyGenerator getWxMaKey(String key) {
        return RedisConfig.WEIXIN_KEY.copy().appendKey(key);
    }

    @Override
    public void expireAccessToken() {
        //token错误时，用于主动执行过期
        redisStringAdapter.remove(getWxMaKey(this.accessTokenKey));
        super.expireAccessToken();
    }

    @Override
    public String getAccessToken() {
        return redisStringAdapter.getString(getWxMaKey(this.accessTokenKey));
    }

    @Override
    public boolean isAccessTokenExpired() {
        return !redisStringAdapter.hasKey(getWxMaKey(this.accessTokenKey));
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        redisStringAdapter.set(getWxMaKey(this.accessTokenKey), accessToken, expiresInSeconds - 200);
    }
}
