package com.bxm.localnews.thirdparty.filter.general;

import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.common.constant.AdvertMaterialType;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Objects;

/**
 * @Author: pf.w
 * @Date: 2020/5/13 9:41
 */
@AdverFilter
public class AppCurFilter extends AbstractAdvertFilterHandler {

    @Autowired
    AppVersionSupplyService appVersionSupplyService;


    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {

        // 3.1.4以下不显示互动广告的类型
        advertVOS.removeIf(p->{
            if (Objects.equals(p.getMaterialType(), (byte) AdvertMaterialType.BXM_SSP_ADVERT.getType())) {
                return appVersionSupplyService.isHighVersion(param.getCurVer(), "3.1.4") < 0;
            }
            return false;
        });

        return true;
    }
}
