package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2020/5/13 10:07
 */
@AdverFilter({AdvertTypeEnum.INDEX_POP_WINDOW})
public class IndexPopWindowFilter extends AbstractAdvertFilterHandler {

    @Autowired
    RedisStringAdapter redisStringAdapter;

    @Autowired
    UserIntegrationService userIntegrationService;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {

        String registerChannel = null;
        if (null != param.getUserId()) {
            UserInfoDTO userInfoDTO = param.loadCacheUserInfo();
            if (null != userInfoDTO) {
                registerChannel = userInfoDTO.getRegisterChannel();
            }
        }

        advertVOS.removeIf(advertDTO ->
                super.checkRemoveAdvertInfo(param.getUserId(), advertDTO.getId(), advertDTO.getShowType()));

        if (advertVOS.size() > 0) {
            String finalRegisterChannel = registerChannel;
            advertVOS.removeIf(advertDTO -> !checkAdvertDeliveryObject(finalRegisterChannel, advertDTO
                    .getDeliveryObject()));
        }

        return true;
    }

    /**
     * 如果是首页弹窗广告则判断广告的投放对象和用户的来源是否满足
     *
     * @param registerChannel
     * @param deliveryObject
     * @return
     */
    private boolean checkAdvertDeliveryObject(String registerChannel, String deliveryObject) {
        if (StringUtils.isEmpty(deliveryObject) || InviteTypeEnum.ALL.getName().equals(deliveryObject)) {
            return true;
        }

        return StringUtils.isNotEmpty(registerChannel) && registerChannel.equals(deliveryObject);
    }
}
