package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: pf.w
 * @Date: 2020/5/13 10:08
 */
@AdverFilter(AdvertTypeEnum.MINI_PROGRAM_POP_WINDOW)
public class MiniProgramPopWindowFilter extends AbstractAdvertFilterHandler {

    @Autowired
    RedisStringAdapter redisStringAdapter;

    @Autowired
    UserIntegrationService userIntegrationService;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
//        advertVOS.stream().filter(advertDTO ->
//                !super.checkRemoveAdvertInfo( param.getUserId(), advertDTO.getId(), advertDTO.getShowType()))
//                .collect(Collectors.toList());

        advertVOS.removeIf(advertDTO->super.checkRemoveAdvertInfo( param.getUserId(), advertDTO.getId(), advertDTO
                .getShowType()));
        return true;
    }
}
