package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Objects;

/**
 * 合伙人拦截处理
 *
 * @author lowi
 * @date 2021/2/3 15:17
 */
@AdverFilter({AdvertTypeEnum.H5_MY_PAGE, AdvertTypeEnum.H5_GOODS_INFO, AdvertTypeEnum.H5_MEMBER_DAY_MALL})
@Slf4j
@AllArgsConstructor
public class PartnerPositionAdverFilter extends AbstractAdvertFilterHandler {
    private final UserIntegrationService userIntegrationService;

    private final LocationFacadeService locationFacadeService;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        UserInfoDTO userInfo = param.getUserInfo();
        if (Objects.isNull(userInfo)) {
            UserInfoDTO userFromRedisDB = userIntegrationService.getUserFromRedisDB(param.getUserId());
            param.setUserInfo(userFromRedisDB);
            userInfo = userFromRedisDB;
        }
        UserInfoDTO finalUserInfo = userInfo;
        advertVOS.forEach(advertVO -> {
            //是否为达人
            boolean talent = finalUserInfo.getTalentLevel() != null && !Objects.equals(finalUserInfo.getTalentLevel(), 0);
            advertVO.setAddress(talentUrl(advertVO.getAddress(), talent ? 1 : 0, param.getAreaCode(), param.getUserId()));
        });
        return false;
    }

    /**
     * 拼接url
     *
     * @param address  原跳转url
     * @param isTalent 是否是达人 0非 1是
     * @return 拼接好的url
     */
    private String talentUrl(String address, Integer isTalent, String areaCode, Long userId) {
        LocationDetailDTO locationDetailByCode = locationFacadeService.getLocationDetailByCode(areaCode);
        String areaName = "本地";
        if (Objects.nonNull(locationDetailByCode)) {
            areaName = locationDetailByCode.getName();
        }
        if (StringUtils.isBlank(address)) {
            return address;
        }
        StringBuilder str = new StringBuilder();
        if (address.contains("?")) {
            str.append(address).append("&isTalent=").append(isTalent)
                    .append("&areaName=").append(areaName)
                    .append("&areaCode=").append(areaCode)
                    .append("&userId=").append(userId);
        } else {
            str.append(address).append("?isTalent=").append(isTalent)
                    .append("&areaName=").append(areaName)
                    .append("&areaCode=").append(areaCode)
                    .append("&userId=").append(userId);
        }
        return str.toString();
    }
}
