package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.enums.FollowActEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy.TopShowcaseContextProcess;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author: gengyy
 * @create: 2020-10-23 10:24
 */
@Slf4j
@AdverFilter({AdvertTypeEnum.TOP_SHOWCASE})
@AllArgsConstructor
public class TopShowcaseAdvertFilter extends AbstractAdvertFilterHandler {

    private final TopShowcaseContextProcess contextProcess;

    private final AdverProperties adverProperties;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        //刪除特定类型查不到数据的素材
        advertVOS.removeIf(advert -> removeSpecificType(advert, param));
        //大于设置的banner长度，切割
        if (advertVOS.size() > adverProperties.getTopShowcaseMaxSize()) {
            List<AdvertVO> newAdvertList = new ArrayList<>();
            int advertLength = 0;
            while (advertLength < adverProperties.getTopShowcaseMaxSize()) {
                AdvertVO advertVO = advertVOS.get(advertLength);
                newAdvertList.add(advertVO);
                if(Objects.equals(advertVO.getFollowAct(),FollowActEnum.JUMP_HALF_OFF_GOODS.getType())){
                    //头条橱窗其实只有2种类型，当时SB没考虑到，一种是图片+图片+价格，一直是图片+图片
                    //五折商品为图片+图片+价格，在客户端不需要改动还能兼容的情况下，把这个新类型展示为
                    //客户端能识别的类型
                    advertVO.setFollowAct(FollowActEnum.JUMP_ZERO_BUY.getType());
                }
                advertLength++;
            }
            advertVOS.clear();
            advertVOS.addAll(newAdvertList);
        }
        return true;
    }

    private boolean removeSpecificType(AdvertVO advertVO, AdvertisementParam param) {
        return contextProcess.removeInfo(advertVO, param);
    }

}
