package com.bxm.localnews.thirdparty.filter.position.myTopStrategy;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

/**
 * @author lowi
 * @date 2020/11/20 17:23
 */
@Component
public class MyTopBannerContextProcess {

    private HashMap<String, MyTopBannerStrategy> strategyMap;

    public MyTopBannerContextProcess(List<MyTopBannerStrategy> strategies) {
        strategyMap = new HashMap<>((int) (strategies.size() / .75f) + 1);
        strategies.forEach(entity -> {
            strategyMap.put(entity.getType(), entity);
        });
    }


    public Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param) {
        MyTopBannerStrategy myTopBannerStrategy = strategyMap.get(advertVO.getMaterialContent());
        if (myTopBannerStrategy == null) {
            JSONObject extData = new JSONObject();
            if (advertVO.getExtData() != null) {
                extData = (JSONObject) advertVO.getExtData();
            }
            extData.put("isRedFlower", false);
            advertVO.setExtData(extData);
            return false;
        }
        return strategyMap.get(advertVO.getMaterialContent()).removeInfo(advertVO, param);
    }
}
