package com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.dto.PoolCommodityListItem;
import com.bxm.localnews.integration.CommodityInfoFacadeService;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.enums.FollowActEnum;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.thirdparty.vo.ZeroCommodityAdver;
import com.bxm.newidea.component.vo.PageParam;
import com.gexin.fastjson.JSON;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.C;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

import static org.apache.commons.lang3.StringUtils.isNumeric;

/**
 * @author lowi
 * @date 2020/11/20 17:35
 */
@Component
@AllArgsConstructor
@Slf4j
public class GoodsActiveStrategy extends TopShowcaseStrategy {

    private final CommodityInfoFacadeService commodityInfoFacadeService;

    @Override
    public Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param) {
        // 商品池
        if (StringUtils.isNotBlank(advertVO.getAdzoneId()) && isNumeric(advertVO.getAdzoneId())) {
            PoolCommodityListItem commodityExtData = getCommodityExtData(param, Long.parseLong(advertVO.getAdzoneId()));
            if (Objects.nonNull(commodityExtData)) {
                ZeroCommodityAdver zeroCommodityAdver = convert(commodityExtData);
                // 商品池的跳转在followContent中
                zeroCommodityAdver.setJumpUrl(advertVO.getFollowContent());
                advertVO.setExtData(zeroCommodityAdver);
                // 兼容客户端原有的跳转
                advertVO.setAddress(advertVO.getFollowContent());
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("获取商品池商品失败，移除广告");
        }
        return true;
    }

    @Override
    public Integer getType() {
        return FollowActEnum.JUMP_GOODS_ACTIVE.getType();
    }

    private PoolCommodityListItem getCommodityExtData(AdvertisementParam param, Long poolId) {
        PageParam pageParam = new PageParam();
        pageParam.setPageNum(1);
        pageParam.setPageSize(3);


        List<PoolCommodityListItem> commodityPoolCommodities = commodityInfoFacadeService.getCommodityPoolCommodities(param,
                pageParam, poolId, param.getUserId());

        if (log.isDebugEnabled()) {
            log.debug("查询商品数据，param: {}, poolId: {}, result: {}", JSON.toJSONString(param), poolId,
                    JSON.toJSONString(commodityPoolCommodities));
        }

        if (!CollectionUtils.isEmpty(commodityPoolCommodities)) {
            return commodityPoolCommodities.get(0);
        }

        return null;
    }

    private ZeroCommodityAdver convert(PoolCommodityListItem commodityExtData) {
        ZeroCommodityAdver zeroCommodityAdver = new ZeroCommodityAdver();
        if (Objects.nonNull(commodityExtData.getCommodityPrice())) {
            try {
                String price = BigDecimal.valueOf(commodityExtData.getCommodityPrice()).stripTrailingZeros().toPlainString();
                zeroCommodityAdver.setPrice(new BigDecimal(price));
            } catch (Exception e) {
                log.error("获取红花夺宝活动商品价格转换错误: [{}],错误信息", commodityExtData, e);
            }
        }
        // 图片地址
        zeroCommodityAdver.setImg(commodityExtData.getImgUrl());
        return zeroCommodityAdver;
    }
}
