package com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.dto.TopShowcaseDTO;
import com.bxm.localnews.integration.MerchantIntegrationService;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.enums.FollowActEnum;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.thirdparty.vo.TopShowcaseExtDataAdver;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2020/11/23 11:38
 */
@Component
@Slf4j
@AllArgsConstructor
public class HalfOffVipStrategy extends TopShowcaseStrategy {
    private final AdverProperties adverProperties;

    private final BaseUrlFacadeService baseUrlFacadeService;

    private final MerchantIntegrationService merchantIntegrationService;

    @Override
    public Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param) {

        TopShowcaseDTO activityGoodsInfo = merchantIntegrationService.getActivityGoodsInfo(param.getAreaCode());
        if (activityGoodsInfo == null) {
            log.info("获取5折会员日/优惠团购活动商品不存在，删除此素材");
            return true;
        }
        TopShowcaseExtDataAdver halfOffGoodsExtData = new TopShowcaseExtDataAdver();
        halfOffGoodsExtData.setImg(activityGoodsInfo.getImg());
        String price = null;
        try {
            price = activityGoodsInfo.getPrice().stripTrailingZeros().toPlainString();
            halfOffGoodsExtData.setPrice(new BigDecimal(price));
        } catch (Exception e) {
            log.error("获取5折会员日/优惠团购活动商品价格转换错误: [{}],错误信息", activityGoodsInfo, e);
            return true;
        }
        halfOffGoodsExtData.setJumpUrl(baseUrlFacadeService.getInnerH5BaseUrl() + adverProperties.getHalfOffVipUrl());
        advertVO.setExtData(halfOffGoodsExtData);
        return false;
    }

    @Override
    public Integer getType() {
        return FollowActEnum.JUMP_HALF_OFF_GOODS.getType();
    }
}
