package com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy;

import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.thirdparty.vo.TopShowcaseOtherAdver;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

/**
 * @author lowi
 * @date 2020/11/20 17:23
 */
@Component
public class TopShowcaseContextProcess {

    private HashMap<Integer, TopShowcaseStrategy> strategyMap;

    public TopShowcaseContextProcess(List<TopShowcaseStrategy> strategies) {
        strategyMap = new HashMap<>((int) (strategies.size() / .75f) + 1);
        strategies.forEach(entity -> strategyMap.put(entity.getType(), entity));
    }


    public Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param) {
        TopShowcaseStrategy topShowcaseStrategy = strategyMap.get(advertVO.getFollowAct());
        if(topShowcaseStrategy==null){
            //其他类型的素材取头像素材为第二张图片
            TopShowcaseOtherAdver topShowcaseOtherAdver = new TopShowcaseOtherAdver();
            topShowcaseOtherAdver.setImg(advertVO.getHeadImg());
            topShowcaseOtherAdver.setJumpUrl(advertVO.getFollowContent());
            advertVO.setExtData(topShowcaseOtherAdver);
            return false;
        }
        return strategyMap.get(advertVO.getFollowAct()).removeInfo(advertVO, param);
    }
}
