package com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy;

import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author lowi
 * @date 2020/11/20 17:19
 */
@Slf4j
@Component
public abstract class TopShowcaseStrategy {


    /**
     * 是否移除广告素材信息
     *
     * @param advertVO 广告西悉尼
     * @param param    基本参数
     * @return true 移除 false 不移除
     */
    public abstract Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param);

    /**
     * 是否移除广告素材信息
     *
     * @return 获取广告素材后续类型
     */
    public abstract Integer getType();
}
