package com.bxm.localnews.thirdparty.service;

import java.util.List;

import com.bxm.localnews.param.DeductPointParam;
import com.bxm.localnews.param.StoreNeceParam;
import com.bxm.localnews.thirdparty.dto.OperateUserPointDTO;
import com.bxm.localnews.thirdparty.dto.PointMallDTO;
import com.bxm.localnews.thirdparty.dto.PointStoreBaseDTO;
import com.bxm.localnews.thirdparty.dto.UserPointDTO;

/**
 * 积分商城对接相关服务接口
 *
 * @author zhaoyadong
 */
public interface PointMallService {

    /**
     * 根据类型获取商品信息
     *
     * @param userId
     * @param type
     * @return
     */
    List<PointMallDTO> getPointsMallByType(Long userId, String type);

    /**
     * 根据id 获取商品信息
     *
     * @param id
     * @param userId
     * @return
     */
    String getPointMallById(Long id, Long userId);


    /**
     *
     * 重定向到特定大转盘活动页
     *
     * @param userId  用户id
     * @param activeId 大转盘活动id
     * @return 重定向
     */
    String redirectToActive(Long userId,Long activeId);

    /**
     * 积分商城回调函数，用于获取支付用户当前持有的金币信息
     *
     * @param storeNeceParam 积分商城回调传入参数
     * @return 用户当前持有金币信息
     */
    UserPointDTO selectJbBalanceByUserId(StoreNeceParam storeNeceParam);

    /**
     * 积分商城回调函数, 用于扣除用户金币
     *
     * @param deductPointParam 积分商城回调传入参数
     * @return 返回扣除当前用户金币的订单号
     */
    OperateUserPointDTO deductUserBalance(DeductPointParam deductPointParam);

    /**
     * 积分商城回调函数，用于扣除金币通知是否扣除成功
     *
     * @param deductPointParam 积分商城回调传入参数
     * @return 当前通知处理成功 返回状态success
     */
    PointStoreBaseDTO deductConfirmUserBalance(DeductPointParam deductPointParam);

    /**
     * 积分商城回调函数， 用于添加用户金币
     *
     * @param deductPointParam 积分商城回调传入参数
     * @return 返回添加当前用户金币的订单号
     */
    OperateUserPointDTO addUserBalance(DeductPointParam deductPointParam);

}
