package com.bxm.localnews.thirdparty.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import com.bxm.localnews.thirdparty.dto.WechatDto;
import com.bxm.localnews.thirdparty.dto.WxMaUserData;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;

public interface WechatService {

    /**
     * 根据appid获取对应的实例
     *
     * @param appid
     * @return
     */
    WxMaService getWxMaService(String appid);

    /**
     * 根据code 获取用户的 openid session_key
     *
     * @param wechatDto
     * @return com.bxm.localnews.thirdparty.dto.WxUserInfo
     * @throws
     */
    WxUserInfo getWechatInfo(WechatDto wechatDto);

    /**
     * 获取微信小程序分享二维码地址
     *
     * @param wechatDto
     * @return java.lang.String
     * @throws
     */
    String getWechatQRCode(WechatDto wechatDto);

    /**
     * 解密数据，创建账号
     *
     * @param wxMaUserData
     * @return java.lang.String
     */
    String createUser(WxMaUserData wxMaUserData);

    /**
     * 设置用户formId
     *
     * @param userId
     * @param formId
     * @return
     */
    Boolean setUserFormId(Long userId, String formId, String appId);

    /**
     * 获取微信token
     *
     * @return
     */
    String getWeChatToken();

    /**
     * 清空微信token
     */
    void emptyWeChatToken();

    /**
     * 判断当前用户是否弹窗
     *
     * @param openId
     * @param platform
     * @return
     */
    Boolean userPopup(String openId, Integer platform);

    /**
     * 获取用户手机号
     *
     * @param wxMaUserData
     * @return
     */
    WxMaPhoneNumberInfo getUserPhoneNum(WxMaUserData wxMaUserData);

    /**
     * 内容是否包含敏感词
     *
     * @param content
     * @return
     */
    Boolean hasSensitiveWord(String content);

    /**
     * 根据类型获取公众号appId
     *
     * @param type 类型
     * @return appId
     */
    String getOfficialAccountAppId(String type);
}
