package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.localnews.common.constant.AdvertMaterialType;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.BXMAdvertisementProperties;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.param.bxm.advertisement.req.*;
import com.bxm.localnews.thirdparty.param.bxm.advertisement.resp.BXMAdvertisementResp;
import com.bxm.localnews.thirdparty.service.AdvertisementFillService;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Slf4j
public class BXMAdvertisementFillService implements AdvertisementFillService {

    @Autowired
    private OKHttpService okHttpService;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private BXMAdvertisementProperties bxmAdvertisementProperties;

    private static final Map<String, String> HEADER = Maps.newHashMap();

    static {
        HEADER.put("Content-Type", "application/json");
    }

    @Override
    public void fill(AdvertisementParam param, List<AdvertVO> advertList) {

        UserInfoDTO user = userIntegrationService.getUserFromRedisDB(param.getUserId());
        UserReq userReq = null;
        if (Objects.nonNull(user)) {
            userReq = new UserReq();
            userReq.setGender(convertGender(user.getSex()));
            userReq.setId(Objects.toString(user.getId()));
            userReq.setKeywords(null);
        }
        UserReq userReqF = userReq;

        advertList.forEach(p -> {
            // FIXME 移除临时代码
            AdReq ext = new AdReq();
            p.setExt(JSON.toJSONString(Arrays.asList(ext)));


            // 配置了SSP广告信息
            if (Objects.equals(p.getMaterialType(), (byte) AdvertMaterialType.BXM_SSP_ADVERT.getType())
                    && StringUtils.isNotBlank(p.getExt())) {

                List<AdReq> adReqs = JSON.parseArray(p.getExt(), AdReq.class);

                BXMAdvertisementReq req = new BXMAdvertisementReq();
                AppReq appReq = null;
                DeviceReq deviceReq = null;

                if (Objects.nonNull(param.getApp())) {
                    appReq = new AppReq();
                    BeanUtils.copyProperties(param.getApp(), appReq);
                }

                if (Objects.nonNull(param.getDevice())) {
                    deviceReq = new DeviceReq();
                    BeanUtils.copyProperties(param.getDevice(), deviceReq);
                }

                req.setVer(param.getCurVer());
                req.setApp(appReq);
                req.setDevice(deviceReq);
                req.setUser(userReqF);
                req.setAds(adReqs);
                req.setTest(bxmAdvertisementProperties.getTest());
                req.setHttps(bxmAdvertisementProperties.getHttps());

                req = JSON.parseObject(bxmAdvertisementProperties.getBxmSspReq(), BXMAdvertisementReq.class);

                try {
                    String reqStr = JSON.toJSONString(req);
                    if (log.isDebugEnabled()) {
                        log.debug("请求变现猫SSP接口参数: {}", reqStr);
                    }
                    String result = okHttpService.postJsonBody("http://47.98.242.33:1892/bidding/bxm", reqStr, HEADER);

                    if (log.isDebugEnabled()) {
                        log.debug("请求变现猫SSP接口返回数据: {}", result);
                    }

                    if (StringUtils.isNotBlank(result)) {
                        BXMAdvertisementResp bxmAdvertisementResp = JSON.parseObject(result, BXMAdvertisementResp.class);

                        if (Objects.nonNull(bxmAdvertisementResp)
                                && Objects.equals(bxmAdvertisementResp.getResult(), 0)) {

                        } else {
                            log.warn("请求变现猫SSP接口失败，请求参数: {}， 返回参数: {}", JSON.toJSONString(req), result);
                        }
                    }
                } catch (Exception e) {
                    log.error("请求变现猫SSP接口出现异常, 请求参数: {}", JSON.toJSONString(req), e);
                }
            }
        });
    }

    /**
     * 转换性别
     *
     * @param sex 0:未知; 1:男; 2:女
     * @return 0:⼥，1:男，2:其他，3:未知
     */
    private Integer convertGender(Byte sex) {
        // param 0:未知; 1:男; 2:女
        if (Objects.isNull(sex)) {
            return 0;
        }

        // return 0:⼥，1:男，2:其他，3:未知
        switch (sex) {
            case 0:
                return 3;
            case 1:
                return 1;
            case 2:
                return 0;
        }

        return 3;
    }

    public static void main(String[] args) {
        OKHttpService service = new OKHttpService();
        String result = service.postJsonBody("http://47.98.242.33:1892/bidding/bxm", "{\"ver\":\"0.1.1\",\"app\":{\"name\":\"wst\",\"bundle\":\"wangshitong\",\"ver\":\"3.0.0\"},\"device\":{\"os\":\"android\",\"os_version\":\"Lollipop\",\"model\":\"redmi\",\"ip\":\"115.206.13.64\",\"make\":\"mi\",\"brand\":\"mi\",\"connection_type\":1,\"orientation\":1,\"ua\":\"Mozilla/5.0 (Linux; U; Android 8.1.0; zh-cn; MI 5X Build/OPM1.171019.019) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.128 Mobile Safari/537.36 XiaoMi/MiuiBrowser/10.8.3\",\"imei\":\"ersltb3B1Yi1pb35NyDA31A0oabakBiJkfI42\",\"screen\":{\"w\":400,\"h\":1000}},\"ads\":[{\"floor_price\":1,\"w\":\"300\",\"h\":\"300\",\"place_token\":\"quanping\"}],\"test\":1}", HEADER);
        System.out.println(result);
    }


}
