package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.thirdparty.service.CrmSendMessageService;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.thirdparty.wxmessage.Message;
import com.bxm.localnews.thirdparty.wxmessage.MsgConfig;
import com.bxm.localnews.thirdparty.wxmessage.UploadImg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.io.File;

@Service
public class CrmSendMessageServiceImpl implements CrmSendMessageService {
    private static final Logger LOG                = LoggerFactory.getLogger(CrmSendMessageServiceImpl.class);
    private static final String SERVICE_HOST       = "https://api.weixin.qq.com";
    /**
     * 微信限制发送图片次数
     */
    private static final int    MAX_SEND_IMG_COUNT = 30;
    /**
     * 微信发送图片次数
     */
    private static int          sendImgCount       = 0;

    @Autowired
    private WechatService wechatService;

    @Autowired
    private HttpClientService httpClientService;

    @Async
    @Override
    public void sendMessageOfImg(String accessToken, Message message, String uploadImagePath) {
        String url = SERVICE_HOST + "/cgi-bin/message/custom/send?access_token=" + accessToken;
        String responseStr = httpClientService.doPost(url, JSON.toJSONString(message));
        // 媒体消息失效，重新更新mediaId并发送
        if (MsgConfig.IMAGE.equals(message.getMsgtype())) {
            JSONObject result = JSON.parseObject(responseStr);
            LOG.info("sendMessageOfImg responseStr:{}", responseStr);
            // 整点的时候替换图片id，防止发送图片限制
            if (sendImgCount == MAX_SEND_IMG_COUNT || "-1".equals(result.getString("errcode"))
                || "40007".equals(result.getString("errcode"))) {
                sendImgCount = 0;
                if (uploadImagePath == null) {
                    return;
                }
                LOG.info("mediaIdOld=" + message.getImage().getMedia_id() + ",uploadImagePath=" + uploadImagePath);
                String weChatToken = wechatService.getWeChatToken();
                String mediaIdNew = UploadImg.uploadImg(weChatToken, new File(uploadImagePath));
                if (mediaIdNew != null) {
                    message.getImage().setMedia_id(mediaIdNew);
                    responseStr = httpClientService.doPost(url, JSON.toJSONString(message));
                    LOG.info("reSendMessageOfImg responseStr:{}", responseStr);
                }
            } else if ("40001".equals(result.getString("errcode"))
                       || "45047".equals(result.getString("errcode"))) {
                wechatService.emptyWeChatToken();
                accessToken = wechatService.getWeChatToken();
                this.sendMessageOfImg(accessToken, message, uploadImagePath);
            } else {
                sendImgCount++;
            }
        }
    }

    @Async
    @Override
    public void sendMessageOfText(String accessToken, Message message) {
        String url = SERVICE_HOST + "/cgi-bin/message/custom/send?access_token=" + accessToken;
        String responseStr = httpClientService.doPost(url, JSON.toJSONString(message));
        JSONObject result = JSON.parseObject(responseStr);
        // 发送失败重新发送
        if ("40001".equals(result.getString("errcode"))
            || "45047".equals(result.getString("errcode"))
            || "-1".equals(result.getString("errcode"))) {
            wechatService.emptyWeChatToken();
            accessToken = wechatService.getWeChatToken();
            this.sendMessageOfText(accessToken, message);
        }
        LOG.info("sendMessageOfText:{}, responseStr:{}", message.getText().getContent(), responseStr);
    }

}
