package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.config.ClientConfigProperties;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.ImIntegrationService;
import com.bxm.localnews.integration.NewsIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.BatchMessageParam;
import com.bxm.localnews.param.ForumPostFacadeParam;
import com.bxm.localnews.param.UserFollowTypeParam;
import com.bxm.localnews.thirdparty.config.PopupProperties;
import com.bxm.localnews.thirdparty.constant.RedisLockKey;
import com.bxm.localnews.thirdparty.param.GuideCloseParam;
import com.bxm.localnews.thirdparty.param.GuideStatusParam;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.GuidePopService;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.AbstractPopStrategy;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.PopOnceStrategy;
import com.bxm.localnews.vo.PostImgVo;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

import static com.bxm.localnews.common.rediskey.UserRedisKey.HASH_USER_ACTIVE_VIP_FIRST;
import static com.bxm.localnews.thirdparty.service.pop.PopTypeEnum.MINE_INVITE_POP;
import static com.bxm.localnews.thirdparty.service.pop.PopTypeEnum.VIP_POSITION_POP;
import static com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.AbstractPopStrategy.KEY;
import static com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.AbstractPopStrategy.NUM;
import static com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum.VER_3_5_0;
import static com.bxm.newidea.component.tools.BitOperatorUtil.getBitAsBoolean;
import static com.gexin.fastjson.JSON.toJSONString;
import static java.util.Objects.isNull;
import static java.util.Objects.nonNull;
import static org.apache.commons.lang3.StringUtils.isBlank;
import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static org.springframework.util.CollectionUtils.isEmpty;

@Slf4j
@Service
public class GuidePopServiceImpl implements GuidePopService {

    @Autowired
    private PopOnceStrategy popOnceStrategy;

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private PopupProperties popupProperties;

    @Autowired
    private ImIntegrationService imIntegrationService;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private LocationFacadeService locationFacadeService;

    @Autowired
    private BizLogService bizLogService;

    @Autowired
    private NewsIntegrationService newsIntegrationService;

    @Autowired
    private ClientConfigProperties clientConfigProperties;

    @Autowired
    private DistributedLock lock;

    @Autowired
    private SequenceCreater sequenceCreater;

    /**
     * 可以抽取一个工具类...
     */
    private static final String USER_NAME = "{userName}";

    private static final String AREA_NAME = "{areaName}";

    @Override
    public boolean guideStatus(GuideStatusParam param) {
        if (isNull(param.getType())) {
            log.warn("获取弹窗状态失败，请求参数有误 param: {}", toJSONString(param));
            return false;
        }

        Optional<PopTypeEnum> byType = PopTypeEnum.getByType(param.getType());
        if (!byType.isPresent()) {
            log.warn("获取弹窗状态失败，请求参数有误 param: {}", toJSONString(param));
            return false;
        }

        if (isNotBlank(param.getCurVer()) && StringUtils.isGrateOrEqualThan(param.getCurVer(), "3.6.0")) {
            // 3.6.0版本之后
            // 判断是否是我的页面 因为其他单个的引导都去掉了....
            if (!Objects.equals(byType.get(), MINE_INVITE_POP)) {
                log.info("3.6.0之后的版本，且不是我的页面的弹窗类型，不弹出 param: {}", toJSONString(param));
                return false;
            }
        }

        // 判断城市是否是开通城市
        LocationDetailDTO locationDetailByCode = locationFacadeService.getLocationDetailByCode(param.getAreaCode());
        // 如果城市未开通 返回不弹出
        if (isNull(locationDetailByCode) || !Objects.equals(locationDetailByCode.getEnableCommunityContent(), 1)) {
            if (log.isDebugEnabled()) {
                log.debug("城市: {} 未开通，返回不弹出引导弹窗", param.getAreaCode());
            }
            return false;
        }

        // 查询用户是否新版本注册的
        UserInfoDTO userFromRedisDB = userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (isNull(userFromRedisDB)
                || isNull(userFromRedisDB.getJudgeMarker())
                // 非新版本注册 没有标志位
                || Objects.equals(Boolean.FALSE, getBitAsBoolean(userFromRedisDB.getJudgeMarker(), VER_3_5_0.getIndex()))) {
            log.info("用户: {} 是老版本注册用户 不弹出引导弹窗", param.getUserId());
            return false;
        }

        // 是否是特殊位置的弹窗 且用户是后来开卡的 则VIP和我的需要再次引导
        specialPositionPopUp(byType.get(), param);

        // 获取缓存
        PopCache popCache = redisHashMapAdapter.get(AbstractPopStrategy.getRedisKey(param.getUserId()),
                byType.get().name(), PopCache.class);

        // 缓存未空 或者未弹出过 提醒客户端弹出
        return isNull(popCache) || popCache.isPopUp();
    }

    private void specialPositionPopUp(PopTypeEnum popType, GuideStatusParam param) {
        // 我知道这个代码很恶心 但是先完成功能吧，下次动到弹窗就好好设计一下
        // 如果是我的、VIP的弹窗缓存 特殊处理
        if (specialPosition(popType)) {
            // 获取弹出缓存
            String info = redisHashMapAdapter.get(HASH_USER_ACTIVE_VIP_FIRST, String.valueOf(param.getUserId()), String.class);
            // 0：不需要弹窗 1: 站外开卡 需要弹出对应的弹窗 2: 站内开卡 需要弹出对应的弹窗 3: 标志特殊弹窗已弹出，首页VIP弹窗需要弹出
            if (isNotBlank(info)) {
                if (Objects.equals("1", info)) {
                    // 1: 站外开卡  则设置VIP和我的弹窗弹出
                    cacheGuidePopup(param.getUserId(), MINE_INVITE_POP.getType(), true);
                    cacheGuidePopup(param.getUserId(), VIP_POSITION_POP.getType(), true);
                    // 设置已弹出过的缓存 但是要控制首页VIP弹出 @see VipActivePop
                    redisHashMapAdapter.put(HASH_USER_ACTIVE_VIP_FIRST, String.valueOf(param.getUserId()),
                            "3");
                } else if (Objects.equals("2", info)) {
                    // 2： 如果是站内开卡，则弹出我的页面弹窗
                    cacheGuidePopup(param.getUserId(), MINE_INVITE_POP.getType(), true);
                    // 设置已弹出过的缓存 但是要控制首页VIP弹出 @see VipActivePop
                    redisHashMapAdapter.put(HASH_USER_ACTIVE_VIP_FIRST, String.valueOf(param.getUserId()),
                            "3");
                }
            }
        }
    }

    /**
     * @param popType popType
     * @return true: 如果是我的、VIP的弹窗缓存
     */
    private boolean specialPosition(PopTypeEnum popType) {
        return Objects.equals(popType, MINE_INVITE_POP)
                || Objects.equals(popType, VIP_POSITION_POP);
    }

    @Override
    public void guideClose(GuideCloseParam closeParam) {

        String key = RedisLockKey.CLOSE_POPUP.copy().appendKey(closeParam.getUserId()).appendKey(closeParam.getType()).gen();
        if (!lock.lock(key, sequenceCreater.nextStringId())) {
            log.warn("用户: {} 重复点击弹窗: {} ", closeParam.getUserId(), closeParam.getType());
            return;
        }

        // 增加缓存弹窗
        cacheGuidePopup(closeParam.getUserId(), closeParam.getType(), false);
        // 引导的后置流程
        afterSpecialGuideClose(closeParam);
    }

    /**
     * 增加缓存弹窗
     *
     * @param userId 用户
     * @param type   弹窗类型
     * @param open   true 则表示未开弹出过需要弹窗 false则不再弹出
     */
    private void cacheGuidePopup(Long userId, Integer type, boolean open) {
        if (isNull(type)) {
            log.warn("关闭弹窗失败，请求参数有误 userId: {} type: {}", userId, type);
            return;
        }

        Optional<PopTypeEnum> popType = PopTypeEnum.getByType(type);
        if (!popType.isPresent()) {
            log.warn("关闭弹窗失败，请求参数有误 userId: {} type: {}", userId, type);
            return;
        }

        // FIXME 增加弹窗缓存 这里太傻了 下一个版本动到弹窗一定要重构
        PopContext context = new PopContext();
        HomeWindowParam param = new HomeWindowParam();
        param.setUserId(userId);
        context.setHomeWindowParam(param);
        context.getParamMap().put(KEY, popType.get().name());

        PopCache cache = new PopCache();
        cache.addParam(NUM, 1);
        cache.setPopUp(open);

        context.setCacheMap(Maps.newHashMap());
        context.getCacheMap().put(popType.get().name(), cache);
        popOnceStrategy.cache(context);
    }

    /**
     * 获取普通用户的给上级发送的消息模板
     *
     * @return
     */
    private String getNormalNoviceUserGuideSentMsgContent(String areaCode) {
        if (isEmpty(popupProperties.getNormalNoviceUserGuideSentMsgContents()) || isBlank(areaCode)) {
            return popupProperties.getDefaultNormalNoviceUserGuideSentMsgContent();
        }

        LocationDetailDTO locationDetailDTO = locationFacadeService.getLocationDetailByCode(areaCode);
        if (isNull(locationDetailDTO)) {
            return popupProperties.getDefaultNormalNoviceUserGuideSentMsgContent();
        }

        String cityName = locationDetailDTO.getName();
        try {
            String str = popupProperties.getNormalNoviceUserGuideSentMsgContents().get(RandomUtils.nextInt(0,
                    popupProperties.getNormalNoviceUserGuideSentMsgContents().size()));
            // 替换城市
            return String.format(str, cityName);
        } catch (Exception e) {
            log.error("模板获取失败", e);
        }

        return popupProperties.getDefaultNormalNoviceUserGuideSentMsgContent();
    }

    /**
     * 获取VIP用户给上级发送的消息模板
     *
     * @return
     */
    private String getVipNoviceUserGuideSentMsgContent() {
        if (isEmpty(popupProperties.getVipNoviceUserGuideSentMsgContents())) {
            return "我已经成功领取你赠送的VIP卡啦，感谢你哦~";
        }

        try {
            return popupProperties.getVipNoviceUserGuideSentMsgContents().get(RandomUtils.nextInt(0,
                    popupProperties.getVipNoviceUserGuideSentMsgContents().size()));
        } catch (Exception e) {
            log.error("获取模板失败", e);
        }

        return "我已经成功领取你赠送的VIP卡啦，感谢你哦~";
    }

    private void afterSpecialGuideClose(GuideCloseParam param) {

        BatchMessageParam messageParam = new BatchMessageParam();
        messageParam.setObjectName("RC:TxtMsg");
        messageParam.setFromUserId(param.getUserId());
        UserInfoDTO userInfo;
        boolean follow = false;
        if (Objects.equals(PopTypeEnum.NORMAL_GUIDE_POP.getType(), param.getType())) {
            // 普通用户引导弹窗
            // 用户如果有一级邀请关系，则在用户完成登录之后，给他的师父发送一个手机消息，消息读取默认库：；例如，你好，感谢你的邀请，我终于来到万事通啦
            messageParam.setContent(getNormalNoviceUserGuideSentMsgContent(param.getAreaCode()));
            // 当新人登录之后，判断如果有一级师徒关系，则自动将双方互相关注。
            follow = true;
            // 新人引导是一个组合，所以那些单个的弹窗也需要进行缓存 避免弹出
            cacheOutGuidePopup(param);
            // 还需要发帖
            postNovicePost(param);
        } else if (Objects.equals(PopTypeEnum.VIP_GUIDE_POP.getType(), param.getType())) {
            // vip用户引导弹窗
            // 点击关闭或者领取并感谢一下，则自动自动发送一个消息给到师傅。消息的文案读取模板库。
            messageParam.setContent(getVipNoviceUserGuideSentMsgContent());
        } else {
            return;
        }

        // 查询上级
        userInfo = userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (isNull(userInfo)) {
            log.warn("用户: {}不存在，无法给上级发送私聊消息", param.getUserId());
            return;
        }

        if (isNull(userInfo.getInviteUserId())) {
            log.info("用户: {} 没有邀请人信息，无法给上级发送私聊消息", param.getUserId());
            return;
        }

        // 发送消息
        messageParam.setToUserId(Collections.singletonList(userInfo.getInviteUserId()));
        imIntegrationService.sendMsg(messageParam);

        PointReportParam reportParam = PointReportParam.build(param)
                .e("3034")
                .ev("123." + userInfo.getInviteUserId())
                .put("uid", String.valueOf(userInfo.getId()));
        bizLogService.report(reportParam);

        // 关注上级 并让上级关注自己
        if (follow) {
            if (log.isDebugEnabled()) {
                log.debug("用户: {} 上级: {}进行相互关注", param.getUserId(), userInfo.getInviteUserId());
            }
            UserFollowTypeParam followParam = new UserFollowTypeParam();
            followParam.setFromUserId(param.getUserId());
            followParam.setToUserId(userInfo.getInviteUserId());
            followParam.setType((byte) 0);
            userIntegrationService.follow(followParam);

            followParam = new UserFollowTypeParam();
            followParam.setFromUserId(userInfo.getInviteUserId());
            followParam.setToUserId(param.getUserId());
            followParam.setType((byte) 0);
            userIntegrationService.follow(followParam);
        }
    }

    /**
     * 增加其他（首页栏目、本地圈、加号、我的）引导缓存的弹窗
     * 普通用户是不需要有其他单个的引导的，只有vip用户需要，所以在普通用户引导关闭的时候，同时缓存其他页面的引导
     *
     * @param param param
     */
    private void cacheOutGuidePopup(GuideCloseParam param) {
        cacheGuidePopup(param.getUserId(), PopTypeEnum.HOME_CHANNEL_POP.getType(), false);
        cacheGuidePopup(param.getUserId(), PopTypeEnum.LOCAL_CYCLE_POP.getType(), false);
        cacheGuidePopup(param.getUserId(), PopTypeEnum.PLUS_POP.getType(), false);
        cacheGuidePopup(param.getUserId(), MINE_INVITE_POP.getType(), false);
        cacheGuidePopup(param.getUserId(), VIP_POSITION_POP.getType(), false);
    }

    /**
     * 发新人帖子
     * @param param
     */
    private void postNovicePost(GuideCloseParam param) {
        // 判断版本
        if (StringUtils.isGrateOrEqualThan(param.getCurVer(), "3.6.0")) {
            // 新版本才发帖
            /**
             {
             "areaCode": "331000000000",
             "topicIdList": [
             92874170306688],
             "isNewReport": 1,
             "title": "",
             "userId": "100107785",
             "location": "知行卡丁车烧烤真人CS团建拓展(城西店)",
             "textField": "新人报到，来混个眼熟，以后我会经常出现",
             "postImgList": [{
             "type": "IMG",
             "imgUrl": "https:\/\/mtest.wstong.com\/localnews_test\/avatar\/16\/10452123335487616.jpeg"
             }]
             }
             */

            // 地址信息 用选择的城市信息
            LocationDetailDTO locationDetailByCode = locationFacadeService.getLocationDetailByCode(param.getAreaCode());
            String locationName = isNull(locationDetailByCode) ? "" : locationDetailByCode.getName();
            UserInfoDTO userInfo = userIntegrationService.getUserFromRedisDB(param.getUserId());

            // 发帖文案
            String publishContent = getPublishContent(userInfo, locationName);

            // 用户头像
            List<PostImgVo> postImg = Collections.emptyList();

            if (nonNull(userInfo)) {
                PostImgVo postImgVo = new PostImgVo();
                postImgVo.setType("IMG");
                postImgVo.setImgUrl(userInfo.getHeadImg());
                postImg = Collections.singletonList(postImgVo);
            }

            ForumPostFacadeParam facadeParam = new ForumPostFacadeParam();
            facadeParam.merge(param);
            facadeParam.setAreaCode(param.getAreaCode());
            facadeParam.setTopicIdList(Collections.singletonList(popupProperties.getNoviceTopicId()));
            facadeParam.setIsNewReport((byte) 1);
            facadeParam.setTitle("");
            facadeParam.setUserId(param.getUserId());
            facadeParam.setLocation(locationName);
            facadeParam.setTextField(publishContent);
            facadeParam.setPostImgList(postImg);

            log.info("用户: {} 发送新人帖子信息: {}", param.getUserId(), toJSONString(facadeParam));

            // 发帖
            newsIntegrationService.createOrUpdatePost(facadeParam);
        }

    }


    private String getPublishContent(UserInfoDTO userInfo, String locationName) {
        String publishContent  = "新人报到，来混个眼熟，以后我会经常出现~";

        if (nonNull(clientConfigProperties.getCommonKeys()) && nonNull(userInfo) && isNotBlank(locationName)) {
            publishContent = clientConfigProperties.getCommonKeys().get("publishContent");
            List<String> publishContents = JSON.parseArray(publishContent, String.class);
            if (!isEmpty(publishContents)) {
                // 随机获取一个
                publishContent = publishContents.get(RandomUtils.nextInt(0, publishContents.size()));
                // 替换关键字
                publishContent = replaceKeyWord(publishContent, userInfo.getNickname(), locationName);
            }
        }

        return publishContent;
    }

    private String replaceKeyWord(String str, String userName, String areaName) {
        if (str.contains(USER_NAME)) {
            str = str.replace(USER_NAME, userName);
        }

        if (str.contains(AREA_NAME)) {
            str = str.replace(AREA_NAME, areaName);
        }

        return str;
    }
}
