package com.bxm.localnews.thirdparty.service.impl;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.*;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.util.MD5Sign;
import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.integration.AccountIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.param.DeductPointParam;
import com.bxm.localnews.param.StoreNeceParam;
import com.bxm.localnews.thirdparty.config.PointMallConfigProperties;
import com.bxm.localnews.thirdparty.constant.PointsMallStatusEnum;
import com.bxm.localnews.thirdparty.constant.PointsMallTypeEnum;
import com.bxm.localnews.thirdparty.domain.PointMallMapper;
import com.bxm.localnews.thirdparty.dto.OperateUserPointDTO;
import com.bxm.localnews.thirdparty.dto.PointMallDTO;
import com.bxm.localnews.thirdparty.dto.PointStoreBaseDTO;
import com.bxm.localnews.thirdparty.dto.UserPointDTO;
import com.bxm.localnews.thirdparty.service.PointMallService;
import com.bxm.localnews.thirdparty.vo.PointMall;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import static org.apache.commons.lang3.StringUtils.isBlank;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

@Service("pointMallSerivce")
public class PointMallServiceImpl extends BaseService implements PointMallService {

    private PointMallConfigProperties pointMallConfigProperties;

    private PointMallMapper pointMallMapper;

    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private UserAccountIntegrationService userAccountIntegrationService;

    @Autowired
    private AccountIntegrationService accountIntegrationService;

    @Autowired
    public PointMallServiceImpl(PointMallConfigProperties pointMallConfigProperties,
                                PointMallMapper pointMallMapper, RedisStringAdapter redisStringAdapter) {
        this.pointMallConfigProperties = pointMallConfigProperties;
        this.pointMallMapper = pointMallMapper;
        this.redisStringAdapter = redisStringAdapter;
    }

    /**
     * 获取积分商城列表的key
     *
     * @return
     */
    private KeyGenerator getPointsMallListKey() {
        return RedisConfig.POINTS_MALL_KEY.copy().appendKey("list");
    }

    /**
     * 获取所有上架的商品
     *
     * @return
     */
    private List<PointMall> getAllPointMall() {
        TypeReference<List<PointMall>> typeReference = new TypeReference<List<PointMall>>() {
        };
        List<PointMall> pointMalls = this.redisStringAdapter.get(this.getPointsMallListKey(), typeReference);

        if (CollectionUtils.isEmpty(pointMalls)) {
            pointMalls = this.pointMallMapper.selectAllByStatus(PointsMallStatusEnum.ON_SHELF.getStatus());
            if (CollectionUtils.isNotEmpty(pointMalls)) {
                //保存一天
                this.redisStringAdapter.set(this.getPointsMallListKey(), pointMalls);
            }
        }

        return pointMalls;
    }

    @Override
    public List<PointMallDTO> getPointsMallByType(Long userId, String type) {
        List<PointMall> pointMalls = getAllPointMall();
        List<PointMallDTO> pointMallDTOS = Lists.newArrayList();

//        for (PointMall pointMall : pointMalls) {
//            if (Byte.valueOf(type).equals(pointMall.getType())) {
//                PointMallDTO pointMallDTO = getPointMallDTOByPointMall(pointMall);
//                pointMallDTOS.add(pointMallDTO);
//            }
//        }
        pointMalls.forEach(pointMall -> {
            if (Byte.valueOf(type).equals(pointMall.getType())) {
                PointMallDTO pointMallDTO = getPointMallDTOByPointMall(pointMall);
                pointMallDTOS.add(pointMallDTO);
            }
        });
        return pointMallDTOS;
    }

    @Override
    public String getPointMallById(Long id, Long userId) {
        List<PointMall> pointMalls = getAllPointMall();
        Optional<PointMall> optional = pointMalls.stream().filter(p -> p.getId().equals(id)).findFirst();
        if (PointsMallTypeEnum.STORE.getType().equals(optional.get().getType())) {
            return generateJumpUrl(userId, StringUtils.EMPTY);
        }
        return generateJumpUrl(userId, optional.get().getUrl());
    }

    @Override
    public String redirectToActive(Long userId, Long activeId) {
        if (Objects.isNull(userId) || Objects.isNull(activeId)) {
            return null;
        }
        List<PointMall> pointMalls = getAllPointMall();
        if (CollectionUtils.isEmpty(pointMalls)) {
            return generateJumpUrl(userId, defaultActiveUrl().replace("{activeId}", activeId.toString()));
        }
        Optional<PointMall> optional = pointMalls.stream().filter(p -> p.getType().equals(PointsMallTypeEnum.LUCKDRAW_ACTIVE.getType())).findFirst();

        return optional.isPresent() ? generateJumpUrl(userId, optional.get().getUrl().replace("{activeId}", activeId.toString())) :
                generateJumpUrl(userId, defaultActiveUrl().replace("{activeId}", activeId.toString()));
    }

    /**
     * 容错的默认连接(正常会去活动库里去取)
     *
     * @return 地址
     */
    private String defaultActiveUrl() {
        return "https://jifen.bianxianmao.com/product/mall/0/activity/0/{activeId}.html";
    }

    @Override
    public UserPointDTO selectJbBalanceByUserId(StoreNeceParam storeNeceParam) {
        HashMap<String, String> map = addCommonParams(storeNeceParam);
        String md5Str = MD5Sign.sign(map, pointMallConfigProperties.getAppSecret());

        if (!md5Str.equals(storeNeceParam.getSign())) {
            return UserPointDTO.fail("签名验证失败");
        }

        String point = userAccountIntegrationService.getUserUsableGold(Long.valueOf(storeNeceParam.getAppUid())).toString();
        return UserPointDTO.success(point);
    }

    @Override
    public OperateUserPointDTO deductUserBalance(DeductPointParam deductPointParam) {

        //获取签名
        HashMap<String, String> map = addCommonParams(deductPointParam);
        map.put("point", deductPointParam.getPoint().toString());
        map.put("orderNum", deductPointParam.getOrderNum());

        String description = decode(deductPointParam.getDescription());
        map.put("description", description);

        String md5Str = MD5Sign.sign(map, pointMallConfigProperties.getAppSecret());

        if (!md5Str.equals(deductPointParam.getSign())) {
            return OperateUserPointDTO.fail("签名验证失败");
        }

        //生成订单号
        String appOrderNum = generateOrderNo();

        deductPointParam.setDescription(description);
        deductPointParam.setAppOrderNum(appOrderNum);
        Boolean isDeduct = accountIntegrationService.deductUserBalance(deductPointParam);

        if (!isDeduct) {
            return OperateUserPointDTO.fail("金币不足");
        }

        return OperateUserPointDTO.success(appOrderNum);
    }

    @Override
    public PointStoreBaseDTO deductConfirmUserBalance(DeductPointParam deductPointParam) {
        //获取签名
        HashMap<String, String> map = addCommonParams(deductPointParam);
        map.put("orderNum", deductPointParam.getOrderNum());
        map.put("status", deductPointParam.getStatus());

        String description = decode(deductPointParam.getDescription());
        map.put("description", description);

        String md5Str = MD5Sign.sign(map, pointMallConfigProperties.getAppSecret());

        if (!md5Str.equals(deductPointParam.getSign())) {
            return PointStoreBaseDTO.fail("签名验证失败");
        }

        deductPointParam.setDescription(description);
        this.accountIntegrationService.deductConfirmUserBalance(deductPointParam);

        return PointStoreBaseDTO.success();
    }

    @Override
    public OperateUserPointDTO addUserBalance(DeductPointParam deductPointParam) {
        HashMap<String, String> map = addCommonParams(deductPointParam);
        map.put("point", deductPointParam.getPoint().toString());
        map.put("orderNum", deductPointParam.getOrderNum());

        String md5Str = MD5Sign.sign(map, pointMallConfigProperties.getAppSecret());

        if (!md5Str.equals(deductPointParam.getSign())) {
            return OperateUserPointDTO.fail("签名验证失败");
        }

        //生成订单号
        String appOrderNum = generateOrderNo();

        String description = "添加金币";
        String status = "ok";
        deductPointParam.setAppOrderNum(appOrderNum);
        deductPointParam.setDescription(description);
        deductPointParam.setStatus(status);
        accountIntegrationService.addUserBalance(deductPointParam);

        return OperateUserPointDTO.success(appOrderNum);
    }

    /**
     * 生成订单号
     *
     * @return
     */
    private String generateOrderNo() {
        String orderPrefix = "Balance";
        return NidGeneratorUtil.getOrderNo(orderPrefix);
    }

    /**
     * 类型转换
     *
     * @param pointMall
     * @return
     */
    private PointMallDTO getPointMallDTOByPointMall(PointMall pointMall) {
        PointMallDTO pointMallDTO = new PointMallDTO();
        pointMallDTO.setImg(pointMall.getImg());
        pointMallDTO.setTitle(pointMall.getTitle());
        pointMallDTO.setId(pointMall.getId());
        pointMallDTO.setDesc(pointMall.getDesc());

        return pointMallDTO;
    }

    /**
     * 组装跳转链接
     *
     * @param userId
     * @param sorceUrl
     * @return
     */
    private String generateJumpUrl(Long userId, String sorceUrl) {
        // 需要拼接参数
        String url = isBlank(sorceUrl) ? sorceUrl : sorceUrl + "&moreBtnType=3&btnTitle=明细";

        HashMap<String, String> map = Maps.newHashMap();
        addCommonParams(map, userId);

        if (isNotBlank(url)) {
            map.put("redirect", url);
        }
        String sign = MD5Sign.sign(map, pointMallConfigProperties.getAppSecret());
        map.put("sign", sign);

        //对跳转的url进行编码
        if (isNotBlank(url)) {
            url = encode(url);
            map.put("redirect", url);
        }

        return getFullLink(map);
    }

    /**
     * 拼接地址
     *
     * @param map
     * @return
     */
    private String getFullLink(Map<String, String> map) {
        //拼接跳转的url
        String params = Joiner.on("&").withKeyValueSeparator("=").join(map);
        String jumpUrl = new StringBuilder().append(pointMallConfigProperties.getStoreUrl())
                .append("?").append(params).toString();

        return jumpUrl;
    }

    /**
     * 签名验证时添加公共参数
     *
     * @param storeNeceParam 积分商城接入参数
     */
    private HashMap<String, String> addCommonParams(StoreNeceParam storeNeceParam) {
        HashMap<String, String> map = Maps.newHashMap();
        map.put("appUid", storeNeceParam.getAppUid());
        map.put("appKey", pointMallConfigProperties.getAppKey());
        map.put("timestamp", storeNeceParam.getTimestamp());
        return map;
    }

    /**
     * 签名验证时添加公共参数
     *
     * @param map
     */
    private void addCommonParams(Map<String, String> map, Long userId) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        map.put("appUid", String.valueOf(userId));
        map.put("appKey", pointMallConfigProperties.getAppKey());
        map.put("appType", pointMallConfigProperties.getAppType());
        map.put("timestamp", timestamp);
    }

    /**
     * 对带有中文的字符串unicode编码之后进行解析
     *
     * @param str
     * @return utf-8的中文
     */
    private String decode(String str) {
        if (isNotBlank(str)) {
            try {
                str = decode(str, "utf-8");
            } catch (Exception e) {
                logger.error("解码失败" + e.getMessage(), e);
            }
        }
        return str;
    }

    /**
     * 对带有中文的字符串根据传入的字符集编码之后进行解析
     *
     * @param str
     * @param enc 字符集
     * @return
     * @throws Exception
     */
    private String decode(String str, String enc) throws Exception {
        return URLDecoder.decode(str, enc);
    }

    /**
     * 对字符串进行unicode编码
     *
     * @param str
     * @return 返回unicode字符串
     */
    private String encode(String str) {
        if (isNotBlank(str)) {
            try {
                str = encode(str, "utf-8");
            } catch (Exception e) {
                logger.error("编码失败" + e.getMessage(), e);
            }
        }
        return str;
    }

    /**
     * 对带有中文的字符串根据传入的字符集编码
     *
     * @param str
     * @param enc 字符集
     * @return
     * @throws Exception
     */
    private String encode(String str, String enc) throws Exception {
        return URLEncoder.encode(str, enc);
    }
}
