package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.PopService;
import com.bxm.localnews.thirdparty.service.pop.PopFactory;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.AbstractPopStrategy;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.PopOnceStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class PopServiceImpl implements PopService {

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private AppVersionSupplyService appVersionSupplyService;

    @Autowired
    private PopFactory popFactory;

    @Autowired
    private PopOnceStrategy popOnceStrategy;

    @Override
    public HomeWindowDTO getHomeWindow(HomeWindowParam homeWindowParam) {
        //调用用户模块，计算上一次到现在的最近访客人数，并发送消息推送，因为2.6.0之前是没有这个功能的，所以之前的需要屏蔽，不发送
        if (appVersionSupplyService.isHighVersion(homeWindowParam.getCurVer(), "2.6.0") != -1) {
            userIntegrationService.sendSystemMessage(homeWindowParam.getUserId());
        }

        return popFactory.process(homeWindowParam);
    }

    @Override
    public void addPrivacyPopCache(Long userId) {
        popOnceStrategy.cache(buildPopContext(userId));
    }

    /**
     * 构建弹窗上下文对象
     *
     * @param userId 用户id
     * @return 弹窗上下文对象
     */
    private PopContext buildPopContext(Long userId) {
        PopContext popContext = new PopContext();
        popContext.setHomeWindowParam(buildHomeWindowParam(userId));
        popContext.addParam(AbstractPopStrategy.KEY, PopTypeEnum.PRIVACY_POP.name());
        PopCache popCache = new PopCache();
        popCache.setPopUp(false);
        popCache.addParam(AbstractPopStrategy.NUM, 1);
        Map<String, PopCache> cacheMap = new HashMap<>();
        cacheMap.put(PopTypeEnum.PRIVACY_POP.name(), popCache);
        popContext.setCacheMap(cacheMap);
        return popContext;
    }

    private HomeWindowParam buildHomeWindowParam(Long userId) {
        HomeWindowParam homeWindowParam = new HomeWindowParam();
        homeWindowParam.setUserId(userId);
        return homeWindowParam;
    }
}
