package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.thirdparty.param.RedirectToWechatMpAuthParam;
import me.chanjar.weixin.common.bean.WxJsapiSignature;

/**
 * @author gonzo
 * @date 2020-08-03 15:34
 **/
public interface WechatMpService {
    /**
     * 根据请求参数，选用中间页域名，组装微信授权页面地址
     * @param param 包含场景类型、redirectUrl参数
     * @return 重定向url
     */
    String wechatMpAuthUrlGen(RedirectToWechatMpAuthParam param);

    /**
     * 创建微信 js pai的验签
     * 方法内部会根据url对应的域名，选用域名对应的公众号进行配置生成验签返回
     *
     * @param sourceUrl  要签名的url
     * @return js pai的签名
     */
    WxJsapiSignature createJsApiSignature(String sourceUrl);
}
