package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.thirdparty.config.XiaojuProperties;
import com.bxm.localnews.thirdparty.dto.XiaojuAuthDTO;
import com.bxm.localnews.thirdparty.dto.XiaojuLinkDTO;
import com.bxm.localnews.thirdparty.param.XiaojuAuthParam;
import com.bxm.localnews.thirdparty.service.XiaojuService;
import com.bxm.localnews.thirdparty.util.AESUtil;
import com.bxm.localnews.thirdparty.util.SignUtil;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

@AllArgsConstructor(onConstructor_ = {@Autowired})
@Service
@Slf4j
public class XiaojuServiceImpl implements XiaojuService {

    private final XiaojuProperties xiaojuProperties;

    @SneakyThrows
    @Override
    public Message getXiaojuLink(XiaojuAuthParam xiaojuAuthParam) {
        String encryptPhone = getPhone(xiaojuAuthParam.getPhone());

        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("encryptPhone", encryptPhone);
        paramMap.put("deliveryMethod", "LINK");
        paramMap.put("openChannel", "1");
        paramMap.put("bizLine", "ENERGY");
        String body = JSONObject.toJSONString(paramMap);
        String result = requestForResult(body, "/user/auth");

        if (StringUtils.isNotBlank(result)) {
            JSONObject jsonObject = JSONObject.parseObject(result);
            String status = jsonObject.getString("status");
            if ("10000".equals(status)) {
                JSONObject dataObj = jsonObject.getJSONObject("data");
                String link = dataObj.getString("link");
                return Message.build(true).addParam("xiaojuLinkDTO",new XiaojuLinkDTO(link));
            }
        }
        log.error("小桔加油隐式登录失败，参数：[{}]，结果：[{}]",JSONObject.toJSONString(xiaojuAuthParam),result);
        return Message.build(false).setMessage("小桔加油隐式登录失败");
    }

    private String getPhone(String phone) throws Exception {
        String key = xiaojuProperties.getAppSecret().substring(0, 16);
        return AESUtil.encrypt(phone, key);
    }

    private String requestForResult(String body, String path) throws Exception {
        /** 构造请求 **/
        URI uri = new URIBuilder()
                .setScheme("https")
                .setHost("open-am.xiaojukeji.com/am/open/api")
                .setPath(path)
                .build();

        HttpPost request = new HttpPost(uri);

        /** 构造请求体 **/
        ContentType contentType = ContentType.APPLICATION_JSON;
        StringEntity se = new StringEntity(body, contentType);
        se.setContentEncoding("UTF-8");
        request.setEntity(se);

        /** 构造请求头 **/
        request.setHeader("x-cas-key", xiaojuProperties.getAppKey());

        String date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date());
        request.setHeader("x-date", date);
        request.setHeader("content-type", contentType.getMimeType());
        request.setHeader("content-md5", SignUtil.md5Encrypt(body));

        /** 计算sign **/
        String signSource = SignUtil.buildSignSource(request.getMethod(), body, contentType.getMimeType(), date,  xiaojuProperties.getAppKey(), uri.getPath(), uri.getQuery());
        String sign = SignUtil.calculateSign(signSource,  xiaojuProperties.getAppSecret());
        request.setHeader("sign", sign);

        /** 发送请求 **/
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response = httpclient.execute(request);
        return EntityUtils.toString(response.getEntity());
    }

    @SneakyThrows
    @Override
    public Message getOauthcode(String encryptPhone) {

        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("encryptPhone", encryptPhone);
        String body = JSONObject.toJSONString(paramMap);
        String result = requestForResult(body, "/oauthcode/get");

        if (StringUtils.isNotBlank(result)) {
            XiaojuAuthDTO xiaojuAuthDTO = JSONObject.parseObject(result,XiaojuAuthDTO.class);
            return Message.build(true).addParam("xiaojuAuthDTO",xiaojuAuthDTO);
        }
        log.error("小桔加油获取oauthcode失败,参数:[{}]，结果：[{}]",encryptPhone,result);
        return Message.build(false).setMessage("小桔加油获取oauthcode失败");
    }

    public static void main(String[] args) {
        String query = "a=1&k=1&b=23&f=1&k=33&app_key=app1&timestamp=1501035945348";
        String[] queries = query.split("&");
        TreeMap<String, String> queryMap = new TreeMap<>();
        Arrays.stream(queries).forEach(queryItem -> {
            String[] keyValue = queryItem.split("=");
            queryMap.put(keyValue[0], keyValue[1]);
        });

        StringBuilder sb = new StringBuilder();
        queryMap.forEach((key, value) -> sb.append(key).append(value));
        String result = sb.toString();
        if (result.endsWith("")) {
            result = result.substring(0, result.length() - 1);
        }
        System.out.println(result);
    }
}