package com.bxm.localnews.thirdparty.service.jump;

import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.vo.JumpInfo;

import java.util.Optional;

/**
 * 根据不同的跳转类型，封装对应的跳转链接
 */
public interface JumpInfoConvert {

    /**
     * webview的协议地址
     */
    String WEB_VIEW_PROTOCAL = "wst://web/webDetail?url=";

    /**
     * 转换方法定义
     * @param param 包含用户信息、基本请求参数
     * @return 转换后的包含了跳转协议的对象
     */
    Optional<JumpInfo> convert(JumpInfoConvertParam param);

    /**
     * 支持转换的类型
     * @return 支持转换的类型
     */
    OrderJumpType support();
}
