package com.bxm.localnews.thirdparty.service.jump.impl;

import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.JumpInfoConvert;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import lombok.extern.slf4j.Slf4j;

import java.util.Optional;

/**
 * 封装了处理错误的流程
 * @author Gonzo
 * @date  2020-07-15 17:12
 * @since 3.4.0
 */
@Slf4j
public abstract class AbstractJumpInfoConvert implements JumpInfoConvert {

    @Override
    public Optional<JumpInfo> convert(JumpInfoConvertParam param) {
        try {
            return doConvert(param);
        } catch(Exception e) {
            log.error("处理类型: {} 失败", support(), e);
        }
        return Optional.empty();
    }

    /**
     * 最终处理方法
     * @param param param
     * @return 转换后的包含了跳转协议的对象
     */
    abstract Optional<JumpInfo> doConvert(JumpInfoConvertParam param);
}
