package com.bxm.localnews.thirdparty.service.jump.impl;

import com.bxm.localnews.activity.common.config.ActivityProperties;
import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.JumpInfoConvert;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

import static java.nio.charset.StandardCharsets.UTF_8;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * 卡券跳转订单
 * @author Gonzo
 * @date  2020-07-15 10:04
 * @since 3.4.0
 */
@Slf4j
@Component
@AllArgsConstructor
public class CouponJumpInfoConvert extends AbstractJumpInfoConvert {

    private final ActivityProperties activityProperties;

    private static final String TQ_URL = "http://tq.jfshou.cn/seller/app/classify";

    @Override
    public Optional<JumpInfo> doConvert(JumpInfoConvertParam param) {
        if (Objects.isNull(param.getUserId())) {
            return Optional.empty();
        }
        JumpInfo jumpInfo = new JumpInfo();
        // 源跳转地址
        jumpInfo.setSourceJumpUrl(parseUrl(TQ_URL, param.getUserId()));
        // 协议跳转地址
        jumpInfo.setProtocol(StringUtils.join(WEB_VIEW_PROTOCAL, UriUtils.encode(jumpInfo.getSourceJumpUrl(), Charset.defaultCharset())));
        return Optional.of(jumpInfo);
    }

    /**
     * 解析原始url，进行路径处理
     *
     * @param sourceUrl 运营配置的淘气权益365商品地址
     * @return 处理后的地址
     */
    private String parseUrl(String sourceUrl, Long userId) {

        if (isBlank(sourceUrl) || Objects.isNull(userId)) {
            return sourceUrl;
        }
        StringBuilder sb = new StringBuilder(sourceUrl);
        //增加用户唯一码
        if (sourceUrl.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append("machineCode=").append(userId);

        // 代理商ID
        sb.append("&agentId=").append(activityProperties.getTaoqi365AgentId());

        //时间戳
        sb.append("&timestamp=").append(System.currentTimeMillis());

        //解析URL获取参数信息，计算签名
        String signStr = sb.toString();
        List<NameValuePair> paramList = URLEncodedUtils.parse(StringUtils.substring(signStr, signStr.indexOf("?") + 1), UTF_8);

        paramList = paramList.stream().sorted(Comparator.comparing(NameValuePair::getName))
                .collect(Collectors.toList());

        StringBuilder signSource = new StringBuilder();

        for (NameValuePair nameValuePair : paramList) {
            if (StringUtils.equalsAny(nameValuePair.getName(), activityProperties.getExcludeParam())) {
                continue;
            }

            signSource.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue());
            signSource.append("&");
        }

        signSource.append("secretKey").append("=").append(activityProperties.getTaoqi365SecertKey());

        // 附加签名
        sb.append("&sign=").append(MD5Util.hgmd5(signSource.toString()).toUpperCase());

        return sb.toString();
    }

    @Override
    public OrderJumpType support() {
        return OrderJumpType.COUPON_ORDER;
    }
}
