package com.bxm.localnews.thirdparty.service.jump.impl;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.KfcProperty;
import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.JumpInfoConvert;
import com.bxm.localnews.thirdparty.util.SignUtils;
import com.bxm.localnews.thirdparty.util.UrlParamsUtils;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;
import org.yaml.snakeyaml.util.UriEncoder;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * 千牛肯德基转换
 * @author Gonzo
 * @date  2020-07-15 09:48
 * @since 3.4.0
 */
@Slf4j
@Component
public class QianNiuKfcHomePageJumpInfoConvert extends AbstractJumpInfoConvert {

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private KfcProperty kfcProperty;

    @Override
    public Optional<JumpInfo> doConvert(JumpInfoConvertParam param) {
        UserInfoDTO userInfoDTO = userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (Objects.isNull(userInfoDTO)) {
            return Optional.empty();
        }

        try {
            Map<String, Object> signMap = Maps.newHashMap();
            signMap.put("platformUniqueId", param.getUserId());
            signMap.put("nickname", userInfoDTO.getNickname());
            signMap.put("platformId", kfcProperty.getPlatformId());
            signMap.put("timestamp", System.currentTimeMillis());
            signMap.put("redirectUrl", "/order/list");

            String sign = SignUtils.generateSign(signMap, kfcProperty.getSecret());
            signMap.put("sign", sign);
            signMap.put("nickname", UriEncoder.encode(userInfoDTO.getNickname()));
            String paramStr = UrlParamsUtils.toParams(signMap);


            JumpInfo jumpInfo = new JumpInfo();
            // 源地址
            jumpInfo.setSourceJumpUrl(kfcProperty.getServerUrl() + "/api/v2/platform/login?" + paramStr);
            // 协议地址
            jumpInfo.setProtocol(StringUtils.join(WEB_VIEW_PROTOCAL, UriUtils.encode(jumpInfo.getSourceJumpUrl(), Charset.defaultCharset())));
            return Optional.of(jumpInfo);

        } catch(Exception e) {
            log.error("获取千猪肯德基点餐首页地址失败", e);
        }

        return Optional.empty();
    }

    @Override
    public OrderJumpType support() {
        return OrderJumpType.QIANZHU_KFC_HOMEPAGE;
    }
}
