package com.bxm.localnews.thirdparty.service.jump.impl;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.KfcProperty;
import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.JumpInfoConvert;
import com.bxm.localnews.thirdparty.util.SignUtils;
import com.bxm.localnews.thirdparty.util.UrlParamsUtils;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import com.bxm.newidea.component.tools.StringUtils;
import com.gexin.fastjson.JSON;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;
import org.yaml.snakeyaml.util.UriEncoder;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import static com.gexin.fastjson.JSON.parseObject;
import static java.util.Objects.isNull;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * 千牛肯德基转换
 * @author Gonzo
 * @date  2020-07-15 09:48
 * @since 3.4.0
 */
@Slf4j
@Component
public class QianNiuKfcOrderPageJumpInfoConvert extends AbstractJumpInfoConvert {

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private KfcProperty kfcProperty;

    @Override
    public Optional<JumpInfo> doConvert(JumpInfoConvertParam param) {
        UserInfoDTO userInfoDTO = userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (isNull(userInfoDTO)) {
            return Optional.empty();
        }

        try {
            Map<String, Object> signMap = Maps.newHashMap();
            signMap.put("platformUniqueId", param.getUserId());
            signMap.put("nickname", userInfoDTO.getNickname());
            signMap.put("platformId", kfcProperty.getPlatformId());
            signMap.put("timestamp", System.currentTimeMillis());

            String sign = SignUtils.generateSign(signMap, kfcProperty.getSecret());
            signMap.put("sign", sign);
            signMap.put("nickname", UriEncoder.encode(userInfoDTO.getNickname()));

            String url = kfcProperty.getServerUrl() + "/api/v1/platform/getToken?"
                    + UrlParamsUtils.toParams(signMap);
            if (log.isDebugEnabled()) {
                log.debug("获取千猪token信息url: {}", url);
            }
            String res = OkHttpUtils.getWithDefaultHeader(url, Maps.newHashMap());

            if (log.isDebugEnabled()) {
                log.debug("获取千猪token信息res: {}", res);
            }
            QianZhuUser user;
            QianZhuRes qianZhuRes = parseObject(res, QianZhuRes.class);
            if (isNull(qianZhuRes) || isBlank(qianZhuRes.getData())
                    || isNull((user = parseObject(qianZhuRes.getData(), QianZhuUser.class)))) {
                log.warn("请求千猪获取token失败res: {}", res);
                return Optional.empty();
            }

            Map<String, Object> jumpMap = Maps.newHashMap();
            jumpMap.put("token", user.getAccessToken());
            jumpMap.put("platformId", kfcProperty.getPlatformId());
            String jumpStr = UrlParamsUtils.toParams(jumpMap);

            JumpInfo jumpInfo = new JumpInfo();
            // 源地址
            jumpInfo.setSourceJumpUrl(kfcProperty.getPageUrl() + "/order/list?" + jumpStr);
            // 协议地址
            jumpInfo.setProtocol(StringUtils.join(WEB_VIEW_PROTOCAL, UriUtils.encode(jumpInfo.getSourceJumpUrl(), Charset.defaultCharset())));
            return Optional.of(jumpInfo);

        } catch(Exception e) {
            log.error("获取千猪肯德基点餐订单地址失败", e);
        }

        return Optional.empty();
    }

    @Override
    public OrderJumpType support() {
        return OrderJumpType.QIANZHU_KFC_ORDER;
    }

    @Data
    public static class QianZhuRes {
        /**
         * 	是	string	用户token
         */
        private boolean success;
        /**
         * 	是	int	用户id
         */
        private int code;

        private String message;

        private String data;
    }

    @Data
    public static class QianZhuUser {
        /**
         * 	是	string	用户token
         */
        private String accessToken;
        /**
         * 	是	int	用户id
         */
        private Integer userId;
    }
}
